<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoResponse StructType
 * @subpackage Structs
 */
class VideoResponse extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Total;
    /**
     * The Offset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Offset;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVideoResult
     */
    public $Results;
    /**
     * Constructor method for VideoResponse
     * @uses VideoResponse::setTotal()
     * @uses VideoResponse::setOffset()
     * @uses VideoResponse::setResults()
     * @param int $total
     * @param int $offset
     * @param \ArrayType\ArrayOfVideoResult $results
     */
    public function __construct($total = null, $offset = null, \ArrayType\ArrayOfVideoResult $results = null)
    {
        $this
            ->setTotal($total)
            ->setOffset($offset)
            ->setResults($results);
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\VideoResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param int $offset
     * @return \StructType\VideoResponse
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Results value
     * @return \ArrayType\ArrayOfVideoResult|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @param \ArrayType\ArrayOfVideoResult $results
     * @return \StructType\VideoResponse
     */
    public function setResults(\ArrayType\ArrayOfVideoResult $results = null)
    {
        $this->Results = $results;
        return $this;
    }
}
