<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TranslationRequest StructType
 * @subpackage Structs
 */
class TranslationRequest extends AbstractStructBase
{
    /**
     * The SourceLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SourceLanguage;
    /**
     * The TargetLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TargetLanguage;
    /**
     * Constructor method for TranslationRequest
     * @uses TranslationRequest::setSourceLanguage()
     * @uses TranslationRequest::setTargetLanguage()
     * @param string $sourceLanguage
     * @param string $targetLanguage
     */
    public function __construct($sourceLanguage = null, $targetLanguage = null)
    {
        $this
            ->setSourceLanguage($sourceLanguage)
            ->setTargetLanguage($targetLanguage);
    }
    /**
     * Get SourceLanguage value
     * @return string
     */
    public function getSourceLanguage()
    {
        return $this->SourceLanguage;
    }
    /**
     * Set SourceLanguage value
     * @param string $sourceLanguage
     * @return \StructType\TranslationRequest
     */
    public function setSourceLanguage($sourceLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($sourceLanguage) && !is_string($sourceLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceLanguage, true), gettype($sourceLanguage)), __LINE__);
        }
        $this->SourceLanguage = $sourceLanguage;
        return $this;
    }
    /**
     * Get TargetLanguage value
     * @return string
     */
    public function getTargetLanguage()
    {
        return $this->TargetLanguage;
    }
    /**
     * Set TargetLanguage value
     * @param string $targetLanguage
     * @return \StructType\TranslationRequest
     */
    public function setTargetLanguage($targetLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($targetLanguage) && !is_string($targetLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetLanguage, true), gettype($targetLanguage)), __LINE__);
        }
        $this->TargetLanguage = $targetLanguage;
        return $this;
    }
}
