<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpellResponse StructType
 * @subpackage Structs
 */
class SpellResponse extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Total;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpellResult
     */
    public $Results;
    /**
     * Constructor method for SpellResponse
     * @uses SpellResponse::setTotal()
     * @uses SpellResponse::setResults()
     * @param int $total
     * @param \ArrayType\ArrayOfSpellResult $results
     */
    public function __construct($total = null, \ArrayType\ArrayOfSpellResult $results = null)
    {
        $this
            ->setTotal($total)
            ->setResults($results);
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\SpellResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Results value
     * @return \ArrayType\ArrayOfSpellResult|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @param \ArrayType\ArrayOfSpellResult $results
     * @return \StructType\SpellResponse
     */
    public function setResults(\ArrayType\ArrayOfSpellResult $results = null)
    {
        $this->Results = $results;
        return $this;
    }
}
