<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchResponse StructType
 * @subpackage Structs
 */
class SearchResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Version;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SearchResponse
     */
    public $parameters;
    /**
     * The Query
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Query
     */
    public $Query;
    /**
     * The Spell
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpellResponse
     */
    public $Spell;
    /**
     * The Web
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WebResponse
     */
    public $Web;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImageResponse
     */
    public $Image;
    /**
     * The RelatedSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedSearchResponse
     */
    public $RelatedSearch;
    /**
     * The Video
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VideoResponse
     */
    public $Video;
    /**
     * The InstantAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InstantAnswerResponse
     */
    public $InstantAnswer;
    /**
     * The News
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NewsResponse
     */
    public $News;
    /**
     * The MobileWeb
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MobileWebResponse
     */
    public $MobileWeb;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfError
     */
    public $Errors;
    /**
     * Constructor method for SearchResponse
     * @uses SearchResponse::setVersion()
     * @uses SearchResponse::setParameters()
     * @uses SearchResponse::setQuery()
     * @uses SearchResponse::setSpell()
     * @uses SearchResponse::setWeb()
     * @uses SearchResponse::setImage()
     * @uses SearchResponse::setRelatedSearch()
     * @uses SearchResponse::setVideo()
     * @uses SearchResponse::setInstantAnswer()
     * @uses SearchResponse::setNews()
     * @uses SearchResponse::setMobileWeb()
     * @uses SearchResponse::setErrors()
     * @param string $version
     * @param \StructType\SearchResponse $parameters
     * @param \StructType\Query $query
     * @param \StructType\SpellResponse $spell
     * @param \StructType\WebResponse $web
     * @param \StructType\ImageResponse $image
     * @param \StructType\RelatedSearchResponse $relatedSearch
     * @param \StructType\VideoResponse $video
     * @param \StructType\InstantAnswerResponse $instantAnswer
     * @param \StructType\NewsResponse $news
     * @param \StructType\MobileWebResponse $mobileWeb
     * @param \ArrayType\ArrayOfError $errors
     */
    public function __construct($version = null, \StructType\SearchResponse $parameters = null, \StructType\Query $query = null, \StructType\SpellResponse $spell = null, \StructType\WebResponse $web = null, \StructType\ImageResponse $image = null, \StructType\RelatedSearchResponse $relatedSearch = null, \StructType\VideoResponse $video = null, \StructType\InstantAnswerResponse $instantAnswer = null, \StructType\NewsResponse $news = null, \StructType\MobileWebResponse $mobileWeb = null, \ArrayType\ArrayOfError $errors = null)
    {
        $this
            ->setVersion($version)
            ->setParameters($parameters)
            ->setQuery($query)
            ->setSpell($spell)
            ->setWeb($web)
            ->setImage($image)
            ->setRelatedSearch($relatedSearch)
            ->setVideo($video)
            ->setInstantAnswer($instantAnswer)
            ->setNews($news)
            ->setMobileWeb($mobileWeb)
            ->setErrors($errors);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\SearchResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\SearchResponse
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\SearchResponse $parameters
     * @return \StructType\SearchResponse
     */
    public function setParameters(\StructType\SearchResponse $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get Query value
     * @return \StructType\Query|null
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @param \StructType\Query $query
     * @return \StructType\SearchResponse
     */
    public function setQuery(\StructType\Query $query = null)
    {
        $this->Query = $query;
        return $this;
    }
    /**
     * Get Spell value
     * @return \StructType\SpellResponse|null
     */
    public function getSpell()
    {
        return $this->Spell;
    }
    /**
     * Set Spell value
     * @param \StructType\SpellResponse $spell
     * @return \StructType\SearchResponse
     */
    public function setSpell(\StructType\SpellResponse $spell = null)
    {
        $this->Spell = $spell;
        return $this;
    }
    /**
     * Get Web value
     * @return \StructType\WebResponse|null
     */
    public function getWeb()
    {
        return $this->Web;
    }
    /**
     * Set Web value
     * @param \StructType\WebResponse $web
     * @return \StructType\SearchResponse
     */
    public function setWeb(\StructType\WebResponse $web = null)
    {
        $this->Web = $web;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\ImageResponse|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\ImageResponse $image
     * @return \StructType\SearchResponse
     */
    public function setImage(\StructType\ImageResponse $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get RelatedSearch value
     * @return \StructType\RelatedSearchResponse|null
     */
    public function getRelatedSearch()
    {
        return $this->RelatedSearch;
    }
    /**
     * Set RelatedSearch value
     * @param \StructType\RelatedSearchResponse $relatedSearch
     * @return \StructType\SearchResponse
     */
    public function setRelatedSearch(\StructType\RelatedSearchResponse $relatedSearch = null)
    {
        $this->RelatedSearch = $relatedSearch;
        return $this;
    }
    /**
     * Get Video value
     * @return \StructType\VideoResponse|null
     */
    public function getVideo()
    {
        return $this->Video;
    }
    /**
     * Set Video value
     * @param \StructType\VideoResponse $video
     * @return \StructType\SearchResponse
     */
    public function setVideo(\StructType\VideoResponse $video = null)
    {
        $this->Video = $video;
        return $this;
    }
    /**
     * Get InstantAnswer value
     * @return \StructType\InstantAnswerResponse|null
     */
    public function getInstantAnswer()
    {
        return $this->InstantAnswer;
    }
    /**
     * Set InstantAnswer value
     * @param \StructType\InstantAnswerResponse $instantAnswer
     * @return \StructType\SearchResponse
     */
    public function setInstantAnswer(\StructType\InstantAnswerResponse $instantAnswer = null)
    {
        $this->InstantAnswer = $instantAnswer;
        return $this;
    }
    /**
     * Get News value
     * @return \StructType\NewsResponse|null
     */
    public function getNews()
    {
        return $this->News;
    }
    /**
     * Set News value
     * @param \StructType\NewsResponse $news
     * @return \StructType\SearchResponse
     */
    public function setNews(\StructType\NewsResponse $news = null)
    {
        $this->News = $news;
        return $this;
    }
    /**
     * Get MobileWeb value
     * @return \StructType\MobileWebResponse|null
     */
    public function getMobileWeb()
    {
        return $this->MobileWeb;
    }
    /**
     * Set MobileWeb value
     * @param \StructType\MobileWebResponse $mobileWeb
     * @return \StructType\SearchResponse
     */
    public function setMobileWeb(\StructType\MobileWebResponse $mobileWeb = null)
    {
        $this->MobileWeb = $mobileWeb;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfError|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfError $errors
     * @return \StructType\SearchResponse
     */
    public function setErrors(\ArrayType\ArrayOfError $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
