<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileWebRequest StructType
 * @subpackage Structs
 */
class MobileWebRequest extends AbstractStructBase
{
    /**
     * The Offset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Offset;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMobileWebSearchOption
     */
    public $Options;
    /**
     * Constructor method for MobileWebRequest
     * @uses MobileWebRequest::setOffset()
     * @uses MobileWebRequest::setCount()
     * @uses MobileWebRequest::setOptions()
     * @param int $offset
     * @param int $count
     * @param \ArrayType\ArrayOfMobileWebSearchOption $options
     */
    public function __construct($offset = null, $count = null, \ArrayType\ArrayOfMobileWebSearchOption $options = null)
    {
        $this
            ->setOffset($offset)
            ->setCount($count)
            ->setOptions($options);
    }
    /**
     * Get Offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param int $offset
     * @return \StructType\MobileWebRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\MobileWebRequest
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfMobileWebSearchOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfMobileWebSearchOption $options
     * @return \StructType\MobileWebRequest
     */
    public function setOptions(\ArrayType\ArrayOfMobileWebSearchOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
}
