<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebSearchTag ArrayType
 * @subpackage Arrays
 */
class ArrayOfWebSearchTag extends AbstractStructArrayBase
{
    /**
     * The WebSearchTag
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WebSearchTag[]
     */
    public $WebSearchTag;
    /**
     * Constructor method for ArrayOfWebSearchTag
     * @uses ArrayOfWebSearchTag::setWebSearchTag()
     * @param \StructType\WebSearchTag[] $webSearchTag
     */
    public function __construct(array $webSearchTag = array())
    {
        $this
            ->setWebSearchTag($webSearchTag);
    }
    /**
     * Get WebSearchTag value
     * @return \StructType\WebSearchTag[]|null
     */
    public function getWebSearchTag()
    {
        return $this->WebSearchTag;
    }
    /**
     * This method is responsible for validating the values passed to the setWebSearchTag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebSearchTag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebSearchTagForArrayConstraintsFromSetWebSearchTag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWebSearchTagWebSearchTagItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebSearchTagWebSearchTagItem instanceof \StructType\WebSearchTag) {
                $invalidValues[] = is_object($arrayOfWebSearchTagWebSearchTagItem) ? get_class($arrayOfWebSearchTagWebSearchTagItem) : sprintf('%s(%s)', gettype($arrayOfWebSearchTagWebSearchTagItem), var_export($arrayOfWebSearchTagWebSearchTagItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WebSearchTag property can only contain items of type \StructType\WebSearchTag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WebSearchTag value
     * @throws \InvalidArgumentException
     * @param \StructType\WebSearchTag[] $webSearchTag
     * @return \ArrayType\ArrayOfWebSearchTag
     */
    public function setWebSearchTag(array $webSearchTag = array())
    {
        // validation for constraint: array
        if ('' !== ($webSearchTagArrayErrorMessage = self::validateWebSearchTagForArrayConstraintsFromSetWebSearchTag($webSearchTag))) {
            throw new \InvalidArgumentException($webSearchTagArrayErrorMessage, __LINE__);
        }
        $this->WebSearchTag = $webSearchTag;
        return $this;
    }
    /**
     * Add item to WebSearchTag value
     * @throws \InvalidArgumentException
     * @param \StructType\WebSearchTag $item
     * @return \ArrayType\ArrayOfWebSearchTag
     */
    public function addToWebSearchTag(\StructType\WebSearchTag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebSearchTag) {
            throw new \InvalidArgumentException(sprintf('The WebSearchTag property can only contain items of type \StructType\WebSearchTag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WebSearchTag[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebSearchTag|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebSearchTag|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebSearchTag|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebSearchTag|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebSearchTag|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebSearchTag
     */
    public function getAttributeName()
    {
        return 'WebSearchTag';
    }
}
