<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfImageResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfImageResult extends AbstractStructArrayBase
{
    /**
     * The ImageResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageResult[]
     */
    public $ImageResult;
    /**
     * Constructor method for ArrayOfImageResult
     * @uses ArrayOfImageResult::setImageResult()
     * @param \StructType\ImageResult[] $imageResult
     */
    public function __construct(array $imageResult = array())
    {
        $this
            ->setImageResult($imageResult);
    }
    /**
     * Get ImageResult value
     * @return \StructType\ImageResult[]|null
     */
    public function getImageResult()
    {
        return $this->ImageResult;
    }
    /**
     * This method is responsible for validating the values passed to the setImageResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageResultForArrayConstraintsFromSetImageResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfImageResultImageResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfImageResultImageResultItem instanceof \StructType\ImageResult) {
                $invalidValues[] = is_object($arrayOfImageResultImageResultItem) ? get_class($arrayOfImageResultImageResultItem) : sprintf('%s(%s)', gettype($arrayOfImageResultImageResultItem), var_export($arrayOfImageResultImageResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageResult property can only contain items of type \StructType\ImageResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageResult[] $imageResult
     * @return \ArrayType\ArrayOfImageResult
     */
    public function setImageResult(array $imageResult = array())
    {
        // validation for constraint: array
        if ('' !== ($imageResultArrayErrorMessage = self::validateImageResultForArrayConstraintsFromSetImageResult($imageResult))) {
            throw new \InvalidArgumentException($imageResultArrayErrorMessage, __LINE__);
        }
        $this->ImageResult = $imageResult;
        return $this;
    }
    /**
     * Add item to ImageResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageResult $item
     * @return \ArrayType\ArrayOfImageResult
     */
    public function addToImageResult(\StructType\ImageResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageResult) {
            throw new \InvalidArgumentException(sprintf('The ImageResult property can only contain items of type \StructType\ImageResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ImageResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ImageResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ImageResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ImageResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ImageResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ImageResult
     */
    public function getAttributeName()
    {
        return 'ImageResult';
    }
}
