<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebRequest StructType
 * @subpackage Structs
 */
class WebRequest extends AbstractStructBase
{
    /**
     * The Offset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Offset;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The FileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileType;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWebSearchOption
     */
    public $Options;
    /**
     * The SearchTags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $SearchTags;
    /**
     * Constructor method for WebRequest
     * @uses WebRequest::setOffset()
     * @uses WebRequest::setCount()
     * @uses WebRequest::setFileType()
     * @uses WebRequest::setOptions()
     * @uses WebRequest::setSearchTags()
     * @param int $offset
     * @param int $count
     * @param string $fileType
     * @param \ArrayType\ArrayOfWebSearchOption $options
     * @param \ArrayType\ArrayOfString $searchTags
     */
    public function __construct($offset = null, $count = null, $fileType = null, \ArrayType\ArrayOfWebSearchOption $options = null, \ArrayType\ArrayOfString $searchTags = null)
    {
        $this
            ->setOffset($offset)
            ->setCount($count)
            ->setFileType($fileType)
            ->setOptions($options)
            ->setSearchTags($searchTags);
    }
    /**
     * Get Offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param int $offset
     * @return \StructType\WebRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\WebRequest
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \StructType\WebRequest
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfWebSearchOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfWebSearchOption $options
     * @return \StructType\WebRequest
     */
    public function setOptions(\ArrayType\ArrayOfWebSearchOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get SearchTags value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getSearchTags()
    {
        return $this->SearchTags;
    }
    /**
     * Set SearchTags value
     * @param \ArrayType\ArrayOfString $searchTags
     * @return \StructType\WebRequest
     */
    public function setSearchTags(\ArrayType\ArrayOfString $searchTags = null)
    {
        $this->SearchTags = $searchTags;
        return $this;
    }
}
