<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsResult StructType
 * @subpackage Structs
 */
class NewsResult extends AbstractStructBase
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The Snippet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Snippet;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The BreakingNews
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BreakingNews;
    /**
     * The NewsCollections
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNewsCollection
     */
    public $NewsCollections;
    /**
     * Constructor method for NewsResult
     * @uses NewsResult::setTitle()
     * @uses NewsResult::setUrl()
     * @uses NewsResult::setSource()
     * @uses NewsResult::setSnippet()
     * @uses NewsResult::setDate()
     * @uses NewsResult::setBreakingNews()
     * @uses NewsResult::setNewsCollections()
     * @param string $title
     * @param string $url
     * @param string $source
     * @param string $snippet
     * @param string $date
     * @param int $breakingNews
     * @param \ArrayType\ArrayOfNewsCollection $newsCollections
     */
    public function __construct($title = null, $url = null, $source = null, $snippet = null, $date = null, $breakingNews = null, \ArrayType\ArrayOfNewsCollection $newsCollections = null)
    {
        $this
            ->setTitle($title)
            ->setUrl($url)
            ->setSource($source)
            ->setSnippet($snippet)
            ->setDate($date)
            ->setBreakingNews($breakingNews)
            ->setNewsCollections($newsCollections);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\NewsResult
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\NewsResult
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\NewsResult
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Snippet value
     * @return string|null
     */
    public function getSnippet()
    {
        return $this->Snippet;
    }
    /**
     * Set Snippet value
     * @param string $snippet
     * @return \StructType\NewsResult
     */
    public function setSnippet($snippet = null)
    {
        // validation for constraint: string
        if (!is_null($snippet) && !is_string($snippet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($snippet, true), gettype($snippet)), __LINE__);
        }
        $this->Snippet = $snippet;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\NewsResult
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get BreakingNews value
     * @return int|null
     */
    public function getBreakingNews()
    {
        return $this->BreakingNews;
    }
    /**
     * Set BreakingNews value
     * @param int $breakingNews
     * @return \StructType\NewsResult
     */
    public function setBreakingNews($breakingNews = null)
    {
        // validation for constraint: int
        if (!is_null($breakingNews) && !(is_int($breakingNews) || ctype_digit($breakingNews))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($breakingNews, true), gettype($breakingNews)), __LINE__);
        }
        $this->BreakingNews = $breakingNews;
        return $this;
    }
    /**
     * Get NewsCollections value
     * @return \ArrayType\ArrayOfNewsCollection|null
     */
    public function getNewsCollections()
    {
        return $this->NewsCollections;
    }
    /**
     * Set NewsCollections value
     * @param \ArrayType\ArrayOfNewsCollection $newsCollections
     * @return \StructType\NewsResult
     */
    public function setNewsCollections(\ArrayType\ArrayOfNewsCollection $newsCollections = null)
    {
        $this->NewsCollections = $newsCollections;
        return $this;
    }
}
