<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfWebResult extends AbstractStructArrayBase
{
    /**
     * The WebResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WebResult[]
     */
    public $WebResult;
    /**
     * Constructor method for ArrayOfWebResult
     * @uses ArrayOfWebResult::setWebResult()
     * @param \StructType\WebResult[] $webResult
     */
    public function __construct(array $webResult = array())
    {
        $this
            ->setWebResult($webResult);
    }
    /**
     * Get WebResult value
     * @return \StructType\WebResult[]|null
     */
    public function getWebResult()
    {
        return $this->WebResult;
    }
    /**
     * This method is responsible for validating the values passed to the setWebResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebResultForArrayConstraintsFromSetWebResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWebResultWebResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebResultWebResultItem instanceof \StructType\WebResult) {
                $invalidValues[] = is_object($arrayOfWebResultWebResultItem) ? get_class($arrayOfWebResultWebResultItem) : sprintf('%s(%s)', gettype($arrayOfWebResultWebResultItem), var_export($arrayOfWebResultWebResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WebResult property can only contain items of type \StructType\WebResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WebResult value
     * @throws \InvalidArgumentException
     * @param \StructType\WebResult[] $webResult
     * @return \ArrayType\ArrayOfWebResult
     */
    public function setWebResult(array $webResult = array())
    {
        // validation for constraint: array
        if ('' !== ($webResultArrayErrorMessage = self::validateWebResultForArrayConstraintsFromSetWebResult($webResult))) {
            throw new \InvalidArgumentException($webResultArrayErrorMessage, __LINE__);
        }
        $this->WebResult = $webResult;
        return $this;
    }
    /**
     * Add item to WebResult value
     * @throws \InvalidArgumentException
     * @param \StructType\WebResult $item
     * @return \ArrayType\ArrayOfWebResult
     */
    public function addToWebResult(\StructType\WebResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebResult) {
            throw new \InvalidArgumentException(sprintf('The WebResult property can only contain items of type \StructType\WebResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WebResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebResult
     */
    public function getAttributeName()
    {
        return 'WebResult';
    }
}
