<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNewsResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfNewsResult extends AbstractStructArrayBase
{
    /**
     * The NewsResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NewsResult[]
     */
    public $NewsResult;
    /**
     * Constructor method for ArrayOfNewsResult
     * @uses ArrayOfNewsResult::setNewsResult()
     * @param \StructType\NewsResult[] $newsResult
     */
    public function __construct(array $newsResult = array())
    {
        $this
            ->setNewsResult($newsResult);
    }
    /**
     * Get NewsResult value
     * @return \StructType\NewsResult[]|null
     */
    public function getNewsResult()
    {
        return $this->NewsResult;
    }
    /**
     * This method is responsible for validating the values passed to the setNewsResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNewsResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNewsResultForArrayConstraintsFromSetNewsResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNewsResultNewsResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfNewsResultNewsResultItem instanceof \StructType\NewsResult) {
                $invalidValues[] = is_object($arrayOfNewsResultNewsResultItem) ? get_class($arrayOfNewsResultNewsResultItem) : sprintf('%s(%s)', gettype($arrayOfNewsResultNewsResultItem), var_export($arrayOfNewsResultNewsResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NewsResult property can only contain items of type \StructType\NewsResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NewsResult value
     * @throws \InvalidArgumentException
     * @param \StructType\NewsResult[] $newsResult
     * @return \ArrayType\ArrayOfNewsResult
     */
    public function setNewsResult(array $newsResult = array())
    {
        // validation for constraint: array
        if ('' !== ($newsResultArrayErrorMessage = self::validateNewsResultForArrayConstraintsFromSetNewsResult($newsResult))) {
            throw new \InvalidArgumentException($newsResultArrayErrorMessage, __LINE__);
        }
        $this->NewsResult = $newsResult;
        return $this;
    }
    /**
     * Add item to NewsResult value
     * @throws \InvalidArgumentException
     * @param \StructType\NewsResult $item
     * @return \ArrayType\ArrayOfNewsResult
     */
    public function addToNewsResult(\StructType\NewsResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NewsResult) {
            throw new \InvalidArgumentException(sprintf('The NewsResult property can only contain items of type \StructType\NewsResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NewsResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NewsResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NewsResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NewsResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NewsResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NewsResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NewsResult
     */
    public function getAttributeName()
    {
        return 'NewsResult';
    }
}
