<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsResponse StructType
 * @subpackage Structs
 */
class NewsResponse extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Total;
    /**
     * The Offset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Offset;
    /**
     * The RelatedSearches
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNewsRelatedSearch
     */
    public $RelatedSearches;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNewsResult
     */
    public $Results;
    /**
     * Constructor method for NewsResponse
     * @uses NewsResponse::setTotal()
     * @uses NewsResponse::setOffset()
     * @uses NewsResponse::setRelatedSearches()
     * @uses NewsResponse::setResults()
     * @param int $total
     * @param int $offset
     * @param \ArrayType\ArrayOfNewsRelatedSearch $relatedSearches
     * @param \ArrayType\ArrayOfNewsResult $results
     */
    public function __construct($total = null, $offset = null, \ArrayType\ArrayOfNewsRelatedSearch $relatedSearches = null, \ArrayType\ArrayOfNewsResult $results = null)
    {
        $this
            ->setTotal($total)
            ->setOffset($offset)
            ->setRelatedSearches($relatedSearches)
            ->setResults($results);
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\NewsResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param int $offset
     * @return \StructType\NewsResponse
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get RelatedSearches value
     * @return \ArrayType\ArrayOfNewsRelatedSearch|null
     */
    public function getRelatedSearches()
    {
        return $this->RelatedSearches;
    }
    /**
     * Set RelatedSearches value
     * @param \ArrayType\ArrayOfNewsRelatedSearch $relatedSearches
     * @return \StructType\NewsResponse
     */
    public function setRelatedSearches(\ArrayType\ArrayOfNewsRelatedSearch $relatedSearches = null)
    {
        $this->RelatedSearches = $relatedSearches;
        return $this;
    }
    /**
     * Get Results value
     * @return \ArrayType\ArrayOfNewsResult|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @param \ArrayType\ArrayOfNewsResult $results
     * @return \StructType\NewsResponse
     */
    public function setResults(\ArrayType\ArrayOfNewsResult $results = null)
    {
        $this->Results = $results;
        return $this;
    }
}
