<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeepLink ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeepLink extends AbstractStructArrayBase
{
    /**
     * The DeepLink
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DeepLink[]
     */
    public $DeepLink;
    /**
     * Constructor method for ArrayOfDeepLink
     * @uses ArrayOfDeepLink::setDeepLink()
     * @param \StructType\DeepLink[] $deepLink
     */
    public function __construct(array $deepLink = array())
    {
        $this
            ->setDeepLink($deepLink);
    }
    /**
     * Get DeepLink value
     * @return \StructType\DeepLink[]|null
     */
    public function getDeepLink()
    {
        return $this->DeepLink;
    }
    /**
     * This method is responsible for validating the values passed to the setDeepLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeepLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeepLinkForArrayConstraintsFromSetDeepLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeepLinkDeepLinkItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeepLinkDeepLinkItem instanceof \StructType\DeepLink) {
                $invalidValues[] = is_object($arrayOfDeepLinkDeepLinkItem) ? get_class($arrayOfDeepLinkDeepLinkItem) : sprintf('%s(%s)', gettype($arrayOfDeepLinkDeepLinkItem), var_export($arrayOfDeepLinkDeepLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeepLink property can only contain items of type \StructType\DeepLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeepLink value
     * @throws \InvalidArgumentException
     * @param \StructType\DeepLink[] $deepLink
     * @return \ArrayType\ArrayOfDeepLink
     */
    public function setDeepLink(array $deepLink = array())
    {
        // validation for constraint: array
        if ('' !== ($deepLinkArrayErrorMessage = self::validateDeepLinkForArrayConstraintsFromSetDeepLink($deepLink))) {
            throw new \InvalidArgumentException($deepLinkArrayErrorMessage, __LINE__);
        }
        $this->DeepLink = $deepLink;
        return $this;
    }
    /**
     * Add item to DeepLink value
     * @throws \InvalidArgumentException
     * @param \StructType\DeepLink $item
     * @return \ArrayType\ArrayOfDeepLink
     */
    public function addToDeepLink(\StructType\DeepLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeepLink) {
            throw new \InvalidArgumentException(sprintf('The DeepLink property can only contain items of type \StructType\DeepLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeepLink[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeepLink|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeepLink|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeepLink|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeepLink|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeepLink|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeepLink
     */
    public function getAttributeName()
    {
        return 'DeepLink';
    }
}
