<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkHeaderType StructType
 * @subpackage Structs
 */
class WorkHeaderType extends AbstractStructBase
{
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minLength: 1
     * - pattern: [^ ]+ [^/^ ]+/[0-9]+
     * - ref: tns:DocumentNumber
     * - type: tns:DocumentNumber
     * @var string
     */
    public $DocumentNumber;
    /**
     * The ATCUD
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - minLength: 1
     * - ref: tns:ATCUD
     * @var string
     */
    public $ATCUD;
    /**
     * The WorkDate
     * Meta information extracted from the WSDL
     * - ref: tns:WorkDate
     * @var string
     */
    public $WorkDate;
    /**
     * The WorkType
     * Meta information extracted from the WSDL
     * - ref: tns:WorkType
     * @var string
     */
    public $WorkType;
    /**
     * The CustomerTaxID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - minLength: 1
     * - ref: tns:CustomerTaxID
     * @var string
     */
    public $CustomerTaxID;
    /**
     * The CustomerTaxIDCountry
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: [A-Z]{2}|Desconhecido
     * - ref: tns:CustomerTaxIDCountry
     * @var string
     */
    public $CustomerTaxIDCountry;
    /**
     * Constructor method for WorkHeaderType
     * @uses WorkHeaderType::setDocumentNumber()
     * @uses WorkHeaderType::setATCUD()
     * @uses WorkHeaderType::setWorkDate()
     * @uses WorkHeaderType::setWorkType()
     * @uses WorkHeaderType::setCustomerTaxID()
     * @uses WorkHeaderType::setCustomerTaxIDCountry()
     * @param string $documentNumber
     * @param string $aTCUD
     * @param string $workDate
     * @param string $workType
     * @param string $customerTaxID
     * @param string $customerTaxIDCountry
     */
    public function __construct($documentNumber = null, $aTCUD = null, $workDate = null, $workType = null, $customerTaxID = null, $customerTaxIDCountry = null)
    {
        $this
            ->setDocumentNumber($documentNumber)
            ->setATCUD($aTCUD)
            ->setWorkDate($workDate)
            ->setWorkType($workType)
            ->setCustomerTaxID($customerTaxID)
            ->setCustomerTaxIDCountry($customerTaxIDCountry);
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \StructType\WorkHeaderType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($documentNumber) && mb_strlen($documentNumber) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($documentNumber) && mb_strlen($documentNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($documentNumber)), __LINE__);
        }
        // validation for constraint: pattern([^ ]+ [^/^ ]+/[0-9]+)
        if (!is_null($documentNumber) && !preg_match('/[^ ]+ [^\/^ ]+\/[0-9]+/', $documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^ ]+ [^/^ ]+/[0-9]+', var_export($documentNumber, true)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get ATCUD value
     * @return string|null
     */
    public function getATCUD()
    {
        return $this->ATCUD;
    }
    /**
     * Set ATCUD value
     * @param string $aTCUD
     * @return \StructType\WorkHeaderType
     */
    public function setATCUD($aTCUD = null)
    {
        // validation for constraint: string
        if (!is_null($aTCUD) && !is_string($aTCUD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTCUD, true), gettype($aTCUD)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($aTCUD) && mb_strlen($aTCUD) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($aTCUD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aTCUD) && mb_strlen($aTCUD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aTCUD)), __LINE__);
        }
        $this->ATCUD = $aTCUD;
        return $this;
    }
    /**
     * Get WorkDate value
     * @return string|null
     */
    public function getWorkDate()
    {
        return $this->WorkDate;
    }
    /**
     * Set WorkDate value
     * @param string $workDate
     * @return \StructType\WorkHeaderType
     */
    public function setWorkDate($workDate = null)
    {
        // validation for constraint: string
        if (!is_null($workDate) && !is_string($workDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workDate, true), gettype($workDate)), __LINE__);
        }
        $this->WorkDate = $workDate;
        return $this;
    }
    /**
     * Get WorkType value
     * @return string|null
     */
    public function getWorkType()
    {
        return $this->WorkType;
    }
    /**
     * Set WorkType value
     * @uses \EnumType\WorkTypeType::valueIsValid()
     * @uses \EnumType\WorkTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workType
     * @return \StructType\WorkHeaderType
     */
    public function setWorkType($workType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkTypeType::valueIsValid($workType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WorkTypeType', is_array($workType) ? implode(', ', $workType) : var_export($workType, true), implode(', ', \EnumType\WorkTypeType::getValidValues())), __LINE__);
        }
        $this->WorkType = $workType;
        return $this;
    }
    /**
     * Get CustomerTaxID value
     * @return string|null
     */
    public function getCustomerTaxID()
    {
        return $this->CustomerTaxID;
    }
    /**
     * Set CustomerTaxID value
     * @param string $customerTaxID
     * @return \StructType\WorkHeaderType
     */
    public function setCustomerTaxID($customerTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($customerTaxID) && !is_string($customerTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTaxID, true), gettype($customerTaxID)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($customerTaxID) && mb_strlen($customerTaxID) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($customerTaxID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerTaxID) && mb_strlen($customerTaxID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerTaxID)), __LINE__);
        }
        $this->CustomerTaxID = $customerTaxID;
        return $this;
    }
    /**
     * Get CustomerTaxIDCountry value
     * @return string|null
     */
    public function getCustomerTaxIDCountry()
    {
        return $this->CustomerTaxIDCountry;
    }
    /**
     * Set CustomerTaxIDCountry value
     * @param string $customerTaxIDCountry
     * @return \StructType\WorkHeaderType
     */
    public function setCustomerTaxIDCountry($customerTaxIDCountry = null)
    {
        // validation for constraint: string
        if (!is_null($customerTaxIDCountry) && !is_string($customerTaxIDCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTaxIDCountry, true), gettype($customerTaxIDCountry)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}|Desconhecido)
        if (!is_null($customerTaxIDCountry) && !preg_match('/[A-Z]{2}|Desconhecido/', $customerTaxIDCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}|Desconhecido', var_export($customerTaxIDCountry, true)), __LINE__);
        }
        $this->CustomerTaxIDCountry = $customerTaxIDCountry;
        return $this;
    }
}
