<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListInvoiceDocumentsType StructType
 * @subpackage Structs
 */
class ListInvoiceDocumentsType extends AbstractStructBase
{
    /**
     * The invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\InvoiceHeaderType[]
     */
    public $invoice;
    /**
     * Constructor method for ListInvoiceDocumentsType
     * @uses ListInvoiceDocumentsType::setInvoice()
     * @param \StructType\InvoiceHeaderType[] $invoice
     */
    public function __construct(array $invoice = array())
    {
        $this
            ->setInvoice($invoice);
    }
    /**
     * Get invoice value
     * @return \StructType\InvoiceHeaderType[]
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceForArrayConstraintsFromSetInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listInvoiceDocumentsTypeInvoiceItem) {
            // validation for constraint: itemType
            if (!$listInvoiceDocumentsTypeInvoiceItem instanceof \StructType\InvoiceHeaderType) {
                $invalidValues[] = is_object($listInvoiceDocumentsTypeInvoiceItem) ? get_class($listInvoiceDocumentsTypeInvoiceItem) : sprintf('%s(%s)', gettype($listInvoiceDocumentsTypeInvoiceItem), var_export($listInvoiceDocumentsTypeInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The invoice property can only contain items of type \StructType\InvoiceHeaderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set invoice value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceHeaderType[] $invoice
     * @return \StructType\ListInvoiceDocumentsType
     */
    public function setInvoice(array $invoice = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceArrayErrorMessage = self::validateInvoiceForArrayConstraintsFromSetInvoice($invoice))) {
            throw new \InvalidArgumentException($invoiceArrayErrorMessage, __LINE__);
        }
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Add item to invoice value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceHeaderType $item
     * @return \StructType\ListInvoiceDocumentsType
     */
    public function addToInvoice(\StructType\InvoiceHeaderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceHeaderType) {
            throw new \InvalidArgumentException(sprintf('The invoice property can only contain items of type \StructType\InvoiceHeaderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->invoice[] = $item;
        return $this;
    }
}
