<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangeInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeInvoiceStatusRequest $changeInvoiceStatusRequest
     * @return \StructType\ChangeInvoiceStatusResponse|bool
     */
    public function ChangeInvoiceStatus(\StructType\ChangeInvoiceStatusRequest $changeInvoiceStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeInvoiceStatus($changeInvoiceStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeWorkStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeWorkStatusRequest $changeWorkStatusRequest
     * @return \StructType\ChangeWorkStatusResponse|bool
     */
    public function ChangeWorkStatus(\StructType\ChangeWorkStatusRequest $changeWorkStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeWorkStatus($changeWorkStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangePaymentStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangePaymentStatusRequest $changePaymentStatusRequest
     * @return \StructType\ChangePaymentStatusResponse|bool
     */
    public function ChangePaymentStatus(\StructType\ChangePaymentStatusRequest $changePaymentStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangePaymentStatus($changePaymentStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChangeInvoiceStatusResponse|\StructType\ChangePaymentStatusResponse|\StructType\ChangeWorkStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
