<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax StructType
 * Meta information extracted from the WSDL
 * - type: tns:Tax
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The TaxType
     * @var string
     */
    public $TaxType;
    /**
     * The TaxCountryRegion
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: [A-Z]{2}|PT-MA|PT-AC
     * @var string
     */
    public $TaxCountryRegion;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - minLength: 1
     * - pattern: RED|INT|NOR|ISE|OUT|([a-zA-Z0-9.])*|NS|NA
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxPercentage
     * Meta information extracted from the WSDL
     * - base: decimal
     * - choice: TaxPercentage | TotalTaxAmount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * @var float
     */
    public $TaxPercentage;
    /**
     * The TotalTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - choice: TaxPercentage | TotalTaxAmount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * @var float
     */
    public $TotalTaxAmount;
    /**
     * Constructor method for Tax
     * @uses Tax::setTaxType()
     * @uses Tax::setTaxCountryRegion()
     * @uses Tax::setTaxCode()
     * @uses Tax::setTaxPercentage()
     * @uses Tax::setTotalTaxAmount()
     * @param string $taxType
     * @param string $taxCountryRegion
     * @param string $taxCode
     * @param float $taxPercentage
     * @param float $totalTaxAmount
     */
    public function __construct($taxType = null, $taxCountryRegion = null, $taxCode = null, $taxPercentage = null, $totalTaxAmount = null)
    {
        $this
            ->setTaxType($taxType)
            ->setTaxCountryRegion($taxCountryRegion)
            ->setTaxCode($taxCode)
            ->setTaxPercentage($taxPercentage)
            ->setTotalTaxAmount($totalTaxAmount);
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @uses \EnumType\TaxType::valueIsValid()
     * @uses \EnumType\TaxType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxType
     * @return \StructType\Tax
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxType::valueIsValid($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxType', is_array($taxType) ? implode(', ', $taxType) : var_export($taxType, true), implode(', ', \EnumType\TaxType::getValidValues())), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get TaxCountryRegion value
     * @return string|null
     */
    public function getTaxCountryRegion()
    {
        return $this->TaxCountryRegion;
    }
    /**
     * Set TaxCountryRegion value
     * @param string $taxCountryRegion
     * @return \StructType\Tax
     */
    public function setTaxCountryRegion($taxCountryRegion = null)
    {
        // validation for constraint: string
        if (!is_null($taxCountryRegion) && !is_string($taxCountryRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCountryRegion, true), gettype($taxCountryRegion)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}|PT-MA|PT-AC)
        if (!is_null($taxCountryRegion) && !preg_match('/[A-Z]{2}|PT-MA|PT-AC/', $taxCountryRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}|PT-MA|PT-AC', var_export($taxCountryRegion, true)), __LINE__);
        }
        $this->TaxCountryRegion = $taxCountryRegion;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\Tax
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($taxCode) && mb_strlen($taxCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($taxCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxCode) && mb_strlen($taxCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxCode)), __LINE__);
        }
        // validation for constraint: pattern(RED|INT|NOR|ISE|OUT|([a-zA-Z0-9.])*|NS|NA)
        if (!is_null($taxCode) && !preg_match('/RED|INT|NOR|ISE|OUT|([a-zA-Z0-9.])*|NS|NA/', $taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression RED|INT|NOR|ISE|OUT|([a-zA-Z0-9.])*|NS|NA', var_export($taxCode, true)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxPercentage value
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return isset($this->TaxPercentage) ? $this->TaxPercentage : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTaxPercentage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxPercentage method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTaxPercentageForChoiceConstraintsFromSetTaxPercentage($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TotalTaxAmount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TaxPercentage can\'t be set as the property %s is already set. Only one property must be set among these properties: TaxPercentage, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TaxPercentage value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $taxPercentage
     * @return \StructType\Tax
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercentage) && !(is_float($taxPercentage) || is_numeric($taxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        // validation for constraint: choice(TaxPercentage, TotalTaxAmount)
        if ('' !== ($taxPercentageChoiceErrorMessage = self::validateTaxPercentageForChoiceConstraintsFromSetTaxPercentage($taxPercentage))) {
            throw new \InvalidArgumentException($taxPercentageChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($taxPercentage) && $taxPercentage > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($taxPercentage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($taxPercentage) && $taxPercentage < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($taxPercentage, true)), __LINE__);
        }
        if (is_null($taxPercentage) || (is_array($taxPercentage) && empty($taxPercentage))) {
            unset($this->TaxPercentage);
        } else {
            $this->TaxPercentage = $taxPercentage;
        }
        return $this;
    }
    /**
     * Get TotalTaxAmount value
     * @return float|null
     */
    public function getTotalTaxAmount()
    {
        return isset($this->TotalTaxAmount) ? $this->TotalTaxAmount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTotalTaxAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalTaxAmount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTotalTaxAmountForChoiceConstraintsFromSetTotalTaxAmount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TaxPercentage',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TotalTaxAmount can\'t be set as the property %s is already set. Only one property must be set among these properties: TotalTaxAmount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TotalTaxAmount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $totalTaxAmount
     * @return \StructType\Tax
     */
    public function setTotalTaxAmount($totalTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxAmount) && !(is_float($totalTaxAmount) || is_numeric($totalTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxAmount, true), gettype($totalTaxAmount)), __LINE__);
        }
        // validation for constraint: choice(TaxPercentage, TotalTaxAmount)
        if ('' !== ($totalTaxAmountChoiceErrorMessage = self::validateTotalTaxAmountForChoiceConstraintsFromSetTotalTaxAmount($totalTaxAmount))) {
            throw new \InvalidArgumentException($totalTaxAmountChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($totalTaxAmount) && $totalTaxAmount > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($totalTaxAmount, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($totalTaxAmount) && $totalTaxAmount < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($totalTaxAmount, true)), __LINE__);
        }
        if (is_null($totalTaxAmount) || (is_array($totalTaxAmount) && empty($totalTaxAmount))) {
            unset($this->TotalTaxAmount);
        } else {
            $this->TotalTaxAmount = $totalTaxAmount;
        }
        return $this;
    }
}
