<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentHeaderType StructType
 * @subpackage Structs
 */
class PaymentHeaderType extends AbstractStructBase
{
    /**
     * The PaymentRefNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minLength: 1
     * - pattern: [^ ]+ [^/^ ]+/[0-9]+
     * - ref: tns:PaymentRefNo
     * @var string
     */
    public $PaymentRefNo;
    /**
     * The ATCUD
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - minLength: 1
     * - ref: tns:ATCUD
     * @var string
     */
    public $ATCUD;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - ref: tns:TransactionDate
     * @var string
     */
    public $TransactionDate;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - ref: tns:PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The CustomerTaxID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - minLength: 1
     * - ref: tns:CustomerTaxID
     * @var string
     */
    public $CustomerTaxID;
    /**
     * The CustomerTaxIDCountry
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: [A-Z]{2}|Desconhecido
     * - ref: tns:CustomerTaxIDCountry
     * @var string
     */
    public $CustomerTaxIDCountry;
    /**
     * Constructor method for PaymentHeaderType
     * @uses PaymentHeaderType::setPaymentRefNo()
     * @uses PaymentHeaderType::setATCUD()
     * @uses PaymentHeaderType::setTransactionDate()
     * @uses PaymentHeaderType::setPaymentType()
     * @uses PaymentHeaderType::setCustomerTaxID()
     * @uses PaymentHeaderType::setCustomerTaxIDCountry()
     * @param string $paymentRefNo
     * @param string $aTCUD
     * @param string $transactionDate
     * @param string $paymentType
     * @param string $customerTaxID
     * @param string $customerTaxIDCountry
     */
    public function __construct($paymentRefNo = null, $aTCUD = null, $transactionDate = null, $paymentType = null, $customerTaxID = null, $customerTaxIDCountry = null)
    {
        $this
            ->setPaymentRefNo($paymentRefNo)
            ->setATCUD($aTCUD)
            ->setTransactionDate($transactionDate)
            ->setPaymentType($paymentType)
            ->setCustomerTaxID($customerTaxID)
            ->setCustomerTaxIDCountry($customerTaxIDCountry);
    }
    /**
     * Get PaymentRefNo value
     * @return string|null
     */
    public function getPaymentRefNo()
    {
        return $this->PaymentRefNo;
    }
    /**
     * Set PaymentRefNo value
     * @param string $paymentRefNo
     * @return \StructType\PaymentHeaderType
     */
    public function setPaymentRefNo($paymentRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRefNo) && !is_string($paymentRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRefNo, true), gettype($paymentRefNo)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($paymentRefNo) && mb_strlen($paymentRefNo) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($paymentRefNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($paymentRefNo) && mb_strlen($paymentRefNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($paymentRefNo)), __LINE__);
        }
        // validation for constraint: pattern([^ ]+ [^/^ ]+/[0-9]+)
        if (!is_null($paymentRefNo) && !preg_match('/[^ ]+ [^\/^ ]+\/[0-9]+/', $paymentRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^ ]+ [^/^ ]+/[0-9]+', var_export($paymentRefNo, true)), __LINE__);
        }
        $this->PaymentRefNo = $paymentRefNo;
        return $this;
    }
    /**
     * Get ATCUD value
     * @return string|null
     */
    public function getATCUD()
    {
        return $this->ATCUD;
    }
    /**
     * Set ATCUD value
     * @param string $aTCUD
     * @return \StructType\PaymentHeaderType
     */
    public function setATCUD($aTCUD = null)
    {
        // validation for constraint: string
        if (!is_null($aTCUD) && !is_string($aTCUD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTCUD, true), gettype($aTCUD)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($aTCUD) && mb_strlen($aTCUD) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($aTCUD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aTCUD) && mb_strlen($aTCUD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aTCUD)), __LINE__);
        }
        $this->ATCUD = $aTCUD;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\PaymentHeaderType
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \EnumType\PaymentTypeType::valueIsValid()
     * @uses \EnumType\PaymentTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \StructType\PaymentHeaderType
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentTypeType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentTypeType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \EnumType\PaymentTypeType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get CustomerTaxID value
     * @return string|null
     */
    public function getCustomerTaxID()
    {
        return $this->CustomerTaxID;
    }
    /**
     * Set CustomerTaxID value
     * @param string $customerTaxID
     * @return \StructType\PaymentHeaderType
     */
    public function setCustomerTaxID($customerTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($customerTaxID) && !is_string($customerTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTaxID, true), gettype($customerTaxID)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($customerTaxID) && mb_strlen($customerTaxID) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($customerTaxID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerTaxID) && mb_strlen($customerTaxID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerTaxID)), __LINE__);
        }
        $this->CustomerTaxID = $customerTaxID;
        return $this;
    }
    /**
     * Get CustomerTaxIDCountry value
     * @return string|null
     */
    public function getCustomerTaxIDCountry()
    {
        return $this->CustomerTaxIDCountry;
    }
    /**
     * Set CustomerTaxIDCountry value
     * @param string $customerTaxIDCountry
     * @return \StructType\PaymentHeaderType
     */
    public function setCustomerTaxIDCountry($customerTaxIDCountry = null)
    {
        // validation for constraint: string
        if (!is_null($customerTaxIDCountry) && !is_string($customerTaxIDCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTaxIDCountry, true), gettype($customerTaxIDCountry)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}|Desconhecido)
        if (!is_null($customerTaxIDCountry) && !preg_match('/[A-Z]{2}|Desconhecido/', $customerTaxIDCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}|Desconhecido', var_export($customerTaxIDCountry, true)), __LINE__);
        }
        $this->CustomerTaxIDCountry = $customerTaxIDCountry;
        return $this;
    }
}
