<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentTotals StructType
 * @subpackage Structs
 */
class DocumentTotals extends AbstractStructBase
{
    /**
     * The TaxPayable
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * @var float
     */
    public $TaxPayable;
    /**
     * The NetTotal
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * @var float
     */
    public $NetTotal;
    /**
     * The GrossTotal
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * @var float
     */
    public $GrossTotal;
    /**
     * Constructor method for DocumentTotals
     * @uses DocumentTotals::setTaxPayable()
     * @uses DocumentTotals::setNetTotal()
     * @uses DocumentTotals::setGrossTotal()
     * @param float $taxPayable
     * @param float $netTotal
     * @param float $grossTotal
     */
    public function __construct($taxPayable = null, $netTotal = null, $grossTotal = null)
    {
        $this
            ->setTaxPayable($taxPayable)
            ->setNetTotal($netTotal)
            ->setGrossTotal($grossTotal);
    }
    /**
     * Get TaxPayable value
     * @return float|null
     */
    public function getTaxPayable()
    {
        return $this->TaxPayable;
    }
    /**
     * Set TaxPayable value
     * @param float $taxPayable
     * @return \StructType\DocumentTotals
     */
    public function setTaxPayable($taxPayable = null)
    {
        // validation for constraint: float
        if (!is_null($taxPayable) && !(is_float($taxPayable) || is_numeric($taxPayable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPayable, true), gettype($taxPayable)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($taxPayable) && $taxPayable > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($taxPayable, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($taxPayable) && $taxPayable < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($taxPayable, true)), __LINE__);
        }
        $this->TaxPayable = $taxPayable;
        return $this;
    }
    /**
     * Get NetTotal value
     * @return float|null
     */
    public function getNetTotal()
    {
        return $this->NetTotal;
    }
    /**
     * Set NetTotal value
     * @param float $netTotal
     * @return \StructType\DocumentTotals
     */
    public function setNetTotal($netTotal = null)
    {
        // validation for constraint: float
        if (!is_null($netTotal) && !(is_float($netTotal) || is_numeric($netTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netTotal, true), gettype($netTotal)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($netTotal) && $netTotal > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($netTotal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($netTotal) && $netTotal < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($netTotal, true)), __LINE__);
        }
        $this->NetTotal = $netTotal;
        return $this;
    }
    /**
     * Get GrossTotal value
     * @return float|null
     */
    public function getGrossTotal()
    {
        return $this->GrossTotal;
    }
    /**
     * Set GrossTotal value
     * @param float $grossTotal
     * @return \StructType\DocumentTotals
     */
    public function setGrossTotal($grossTotal = null)
    {
        // validation for constraint: float
        if (!is_null($grossTotal) && !(is_float($grossTotal) || is_numeric($grossTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossTotal, true), gettype($grossTotal)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($grossTotal) && $grossTotal > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($grossTotal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($grossTotal) && $grossTotal < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($grossTotal, true)), __LINE__);
        }
        $this->GrossTotal = $grossTotal;
        return $this;
    }
}
