<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for WorkTypeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Deve ser preenchido com: CM Consultas de mesa; CC Credito de consignacao; FC Fatura de consignacao nos termos do art 38 do codigo do IVA; FO Folhas de obra; NE Nota de Encomenda; OU Outros; OR Orcamentos; PF Proforma. Para o setor
 * Segurador, ainda pode ser preenchido com: RP para Premio ou recibo de premio, RE para Estorno ou recibo de estorno, CS para Imputacao a co-seguradoras, LD para Imputacao a co-seguradora lider, RA para Resseguro aceite.
 * @subpackage Enumerations
 */
class WorkTypeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CM'
     * @return string 'CM'
     */
    const VALUE_CM = 'CM';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'FC'
     * @return string 'FC'
     */
    const VALUE_FC = 'FC';
    /**
     * Constant for value 'FO'
     * @return string 'FO'
     */
    const VALUE_FO = 'FO';
    /**
     * Constant for value 'NE'
     * @return string 'NE'
     */
    const VALUE_NE = 'NE';
    /**
     * Constant for value 'OU'
     * @return string 'OU'
     */
    const VALUE_OU = 'OU';
    /**
     * Constant for value 'OR'
     * @return string 'OR'
     */
    const VALUE_OR = 'OR';
    /**
     * Constant for value 'PF'
     * @return string 'PF'
     */
    const VALUE_PF = 'PF';
    /**
     * Constant for value 'RP'
     * @return string 'RP'
     */
    const VALUE_RP = 'RP';
    /**
     * Constant for value 'RE'
     * @return string 'RE'
     */
    const VALUE_RE = 'RE';
    /**
     * Constant for value 'CS'
     * @return string 'CS'
     */
    const VALUE_CS = 'CS';
    /**
     * Constant for value 'LD'
     * @return string 'LD'
     */
    const VALUE_LD = 'LD';
    /**
     * Constant for value 'RA'
     * @return string 'RA'
     */
    const VALUE_RA = 'RA';
    /**
     * Return allowed values
     * @uses self::VALUE_CM
     * @uses self::VALUE_CC
     * @uses self::VALUE_FC
     * @uses self::VALUE_FO
     * @uses self::VALUE_NE
     * @uses self::VALUE_OU
     * @uses self::VALUE_OR
     * @uses self::VALUE_PF
     * @uses self::VALUE_RP
     * @uses self::VALUE_RE
     * @uses self::VALUE_CS
     * @uses self::VALUE_LD
     * @uses self::VALUE_RA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CM,
            self::VALUE_CC,
            self::VALUE_FC,
            self::VALUE_FO,
            self::VALUE_NE,
            self::VALUE_OU,
            self::VALUE_OR,
            self::VALUE_PF,
            self::VALUE_RP,
            self::VALUE_RE,
            self::VALUE_CS,
            self::VALUE_LD,
            self::VALUE_RA,
        );
    }
}
