<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkDataType StructType
 * @subpackage Structs
 */
class WorkDataType extends WorkHeaderType
{
    /**
     * The DocumentStatus
     * @var \StructType\WorkStatus
     */
    public $DocumentStatus;
    /**
     * The HashCharacters
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: [0]|[^^]{4}
     * - ref: tns:HashCharacters
     * - type: tns:HashCharacters
     * @var string
     */
    public $HashCharacters;
    /**
     * The EACCode
     * Meta information extracted from the WSDL
     * - base: string
     * - length: 5
     * - minOccurs: 0
     * - pattern: (([0-9]*))
     * - ref: tns:EACCode
     * - type: tns:EACCode
     * @var string
     */
    public $EACCode;
    /**
     * The SystemEntryDate
     * Meta information extracted from the WSDL
     * - ref: tns:SystemEntryDate
     * @var string
     */
    public $SystemEntryDate;
    /**
     * The LineSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LineSummary[]
     */
    public $LineSummary;
    /**
     * The DocumentTotals
     * @var \StructType\DocumentTotals
     */
    public $DocumentTotals;
    /**
     * Constructor method for WorkDataType
     * @uses WorkDataType::setDocumentStatus()
     * @uses WorkDataType::setHashCharacters()
     * @uses WorkDataType::setEACCode()
     * @uses WorkDataType::setSystemEntryDate()
     * @uses WorkDataType::setLineSummary()
     * @uses WorkDataType::setDocumentTotals()
     * @param \StructType\WorkStatus $documentStatus
     * @param string $hashCharacters
     * @param string $eACCode
     * @param string $systemEntryDate
     * @param \StructType\LineSummary[] $lineSummary
     * @param \StructType\DocumentTotals $documentTotals
     */
    public function __construct(\StructType\WorkStatus $documentStatus = null, $hashCharacters = null, $eACCode = null, $systemEntryDate = null, array $lineSummary = array(), \StructType\DocumentTotals $documentTotals = null)
    {
        $this
            ->setDocumentStatus($documentStatus)
            ->setHashCharacters($hashCharacters)
            ->setEACCode($eACCode)
            ->setSystemEntryDate($systemEntryDate)
            ->setLineSummary($lineSummary)
            ->setDocumentTotals($documentTotals);
    }
    /**
     * Get DocumentStatus value
     * @return \StructType\WorkStatus|null
     */
    public function getDocumentStatus()
    {
        return $this->DocumentStatus;
    }
    /**
     * Set DocumentStatus value
     * @param \StructType\WorkStatus $documentStatus
     * @return \StructType\WorkDataType
     */
    public function setDocumentStatus(\StructType\WorkStatus $documentStatus = null)
    {
        $this->DocumentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get HashCharacters value
     * @return string|null
     */
    public function getHashCharacters()
    {
        return $this->HashCharacters;
    }
    /**
     * Set HashCharacters value
     * @param string $hashCharacters
     * @return \StructType\WorkDataType
     */
    public function setHashCharacters($hashCharacters = null)
    {
        // validation for constraint: string
        if (!is_null($hashCharacters) && !is_string($hashCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashCharacters, true), gettype($hashCharacters)), __LINE__);
        }
        // validation for constraint: pattern([0]|[^^]{4})
        if (!is_null($hashCharacters) && !preg_match('/[0]|[^^]{4}/', $hashCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0]|[^^]{4}', var_export($hashCharacters, true)), __LINE__);
        }
        $this->HashCharacters = $hashCharacters;
        return $this;
    }
    /**
     * Get EACCode value
     * @return string|null
     */
    public function getEACCode()
    {
        return $this->EACCode;
    }
    /**
     * Set EACCode value
     * @param string $eACCode
     * @return \StructType\WorkDataType
     */
    public function setEACCode($eACCode = null)
    {
        // validation for constraint: string
        if (!is_null($eACCode) && !is_string($eACCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eACCode, true), gettype($eACCode)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($eACCode) && mb_strlen($eACCode) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($eACCode)), __LINE__);
        }
        // validation for constraint: pattern((([0-9]*)))
        if (!is_null($eACCode) && !preg_match('/(([0-9]*))/', $eACCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (([0-9]*))', var_export($eACCode, true)), __LINE__);
        }
        $this->EACCode = $eACCode;
        return $this;
    }
    /**
     * Get SystemEntryDate value
     * @return string|null
     */
    public function getSystemEntryDate()
    {
        return $this->SystemEntryDate;
    }
    /**
     * Set SystemEntryDate value
     * @param string $systemEntryDate
     * @return \StructType\WorkDataType
     */
    public function setSystemEntryDate($systemEntryDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemEntryDate) && !is_string($systemEntryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemEntryDate, true), gettype($systemEntryDate)), __LINE__);
        }
        $this->SystemEntryDate = $systemEntryDate;
        return $this;
    }
    /**
     * Get LineSummary value
     * @return \StructType\LineSummary[]|null
     */
    public function getLineSummary()
    {
        return $this->LineSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setLineSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineSummaryForArrayConstraintsFromSetLineSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $workDataTypeLineSummaryItem) {
            // validation for constraint: itemType
            if (!$workDataTypeLineSummaryItem instanceof \StructType\LineSummary) {
                $invalidValues[] = is_object($workDataTypeLineSummaryItem) ? get_class($workDataTypeLineSummaryItem) : sprintf('%s(%s)', gettype($workDataTypeLineSummaryItem), var_export($workDataTypeLineSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineSummary property can only contain items of type \StructType\LineSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSummary[] $lineSummary
     * @return \StructType\WorkDataType
     */
    public function setLineSummary(array $lineSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($lineSummaryArrayErrorMessage = self::validateLineSummaryForArrayConstraintsFromSetLineSummary($lineSummary))) {
            throw new \InvalidArgumentException($lineSummaryArrayErrorMessage, __LINE__);
        }
        $this->LineSummary = $lineSummary;
        return $this;
    }
    /**
     * Add item to LineSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSummary $item
     * @return \StructType\WorkDataType
     */
    public function addToLineSummary(\StructType\LineSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineSummary) {
            throw new \InvalidArgumentException(sprintf('The LineSummary property can only contain items of type \StructType\LineSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineSummary[] = $item;
        return $this;
    }
    /**
     * Get DocumentTotals value
     * @return \StructType\DocumentTotals|null
     */
    public function getDocumentTotals()
    {
        return $this->DocumentTotals;
    }
    /**
     * Set DocumentTotals value
     * @param \StructType\DocumentTotals $documentTotals
     * @return \StructType\WorkDataType
     */
    public function setDocumentTotals(\StructType\DocumentTotals $documentTotals = null)
    {
        $this->DocumentTotals = $documentTotals;
        return $this;
    }
}
