<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithholdingTax StructType
 * @subpackage Structs
 */
class WithholdingTax extends AbstractStructBase
{
    /**
     * The WithholdingTaxType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WithholdingTaxType;
    /**
     * The WithholdingTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * @var float
     */
    public $WithholdingTaxAmount;
    /**
     * Constructor method for WithholdingTax
     * @uses WithholdingTax::setWithholdingTaxType()
     * @uses WithholdingTax::setWithholdingTaxAmount()
     * @param string $withholdingTaxType
     * @param float $withholdingTaxAmount
     */
    public function __construct($withholdingTaxType = null, $withholdingTaxAmount = null)
    {
        $this
            ->setWithholdingTaxType($withholdingTaxType)
            ->setWithholdingTaxAmount($withholdingTaxAmount);
    }
    /**
     * Get WithholdingTaxType value
     * @return string|null
     */
    public function getWithholdingTaxType()
    {
        return $this->WithholdingTaxType;
    }
    /**
     * Set WithholdingTaxType value
     * @uses \EnumType\WithholdingTaxType::valueIsValid()
     * @uses \EnumType\WithholdingTaxType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withholdingTaxType
     * @return \StructType\WithholdingTax
     */
    public function setWithholdingTaxType($withholdingTaxType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WithholdingTaxType::valueIsValid($withholdingTaxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WithholdingTaxType', is_array($withholdingTaxType) ? implode(', ', $withholdingTaxType) : var_export($withholdingTaxType, true), implode(', ', \EnumType\WithholdingTaxType::getValidValues())), __LINE__);
        }
        $this->WithholdingTaxType = $withholdingTaxType;
        return $this;
    }
    /**
     * Get WithholdingTaxAmount value
     * @return float|null
     */
    public function getWithholdingTaxAmount()
    {
        return $this->WithholdingTaxAmount;
    }
    /**
     * Set WithholdingTaxAmount value
     * @param float $withholdingTaxAmount
     * @return \StructType\WithholdingTax
     */
    public function setWithholdingTaxAmount($withholdingTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($withholdingTaxAmount) && !(is_float($withholdingTaxAmount) || is_numeric($withholdingTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($withholdingTaxAmount, true), gettype($withholdingTaxAmount)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($withholdingTaxAmount) && $withholdingTaxAmount > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($withholdingTaxAmount, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($withholdingTaxAmount) && $withholdingTaxAmount < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($withholdingTaxAmount, true)), __LINE__);
        }
        $this->WithholdingTaxAmount = $withholdingTaxAmount;
        return $this;
    }
}
