<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterWorkRequest StructType
 * @subpackage Structs
 */
class RegisterWorkRequest extends AbstractStructBase
{
    /**
     * The eFaturaMDVersion
     * Meta information extracted from the WSDL
     * - documentation: Versao do webservice.
     * - base: string
     * - pattern: 0.0.1
     * - type: tns:eFaturaMDVersion
     * @var string
     */
    public $eFaturaMDVersion;
    /**
     * The AuditFileVersion
     * Meta information extracted from the WSDL
     * - documentation: Campo para indicacao da mais recente versao do SAF-T que consegue criar o software que processa as faturas e comunica por webservice.
     * - base: string
     * - pattern: 1\.04_01|1\.03_01|1\.02_01|1\.01_01|1\.00_01|inexistente
     * - ref: tns:AuditFileVersion
     * - type: tns:AuditFileVersion
     * @var string
     */
    public $AuditFileVersion;
    /**
     * The TaxRegistrationNumber
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxInclusive: 999999999
     * - minInclusive: 100000000
     * - ref: tns:TaxRegistrationNumber
     * @var int
     */
    public $TaxRegistrationNumber;
    /**
     * The TaxEntity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - minLength: 1
     * - ref: tns:TaxEntity
     * @var string
     */
    public $TaxEntity;
    /**
     * The SoftwareCertificateNumber
     * Meta information extracted from the WSDL
     * - ref: tns:SoftwareCertificateNumber
     * @var int
     */
    public $SoftwareCertificateNumber;
    /**
     * The WorkData
     * @var \StructType\WorkDataType
     */
    public $WorkData;
    /**
     * The CanalRegisto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChannelType
     */
    public $CanalRegisto;
    /**
     * Constructor method for RegisterWorkRequest
     * @uses RegisterWorkRequest::setEFaturaMDVersion()
     * @uses RegisterWorkRequest::setAuditFileVersion()
     * @uses RegisterWorkRequest::setTaxRegistrationNumber()
     * @uses RegisterWorkRequest::setTaxEntity()
     * @uses RegisterWorkRequest::setSoftwareCertificateNumber()
     * @uses RegisterWorkRequest::setWorkData()
     * @uses RegisterWorkRequest::setCanalRegisto()
     * @param string $eFaturaMDVersion
     * @param string $auditFileVersion
     * @param int $taxRegistrationNumber
     * @param string $taxEntity
     * @param int $softwareCertificateNumber
     * @param \StructType\WorkDataType $workData
     * @param \StructType\ChannelType $canalRegisto
     */
    public function __construct($eFaturaMDVersion = null, $auditFileVersion = null, $taxRegistrationNumber = null, $taxEntity = null, $softwareCertificateNumber = null, \StructType\WorkDataType $workData = null, \StructType\ChannelType $canalRegisto = null)
    {
        $this
            ->setEFaturaMDVersion($eFaturaMDVersion)
            ->setAuditFileVersion($auditFileVersion)
            ->setTaxRegistrationNumber($taxRegistrationNumber)
            ->setTaxEntity($taxEntity)
            ->setSoftwareCertificateNumber($softwareCertificateNumber)
            ->setWorkData($workData)
            ->setCanalRegisto($canalRegisto);
    }
    /**
     * Get eFaturaMDVersion value
     * @return string|null
     */
    public function getEFaturaMDVersion()
    {
        return $this->eFaturaMDVersion;
    }
    /**
     * Set eFaturaMDVersion value
     * @param string $eFaturaMDVersion
     * @return \StructType\RegisterWorkRequest
     */
    public function setEFaturaMDVersion($eFaturaMDVersion = null)
    {
        // validation for constraint: string
        if (!is_null($eFaturaMDVersion) && !is_string($eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eFaturaMDVersion, true), gettype($eFaturaMDVersion)), __LINE__);
        }
        // validation for constraint: pattern(0.0.1)
        if (!is_null($eFaturaMDVersion) && !preg_match('/0.0.1/', $eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 0.0.1', var_export($eFaturaMDVersion, true)), __LINE__);
        }
        $this->eFaturaMDVersion = $eFaturaMDVersion;
        return $this;
    }
    /**
     * Get AuditFileVersion value
     * @return string|null
     */
    public function getAuditFileVersion()
    {
        return $this->AuditFileVersion;
    }
    /**
     * Set AuditFileVersion value
     * @param string $auditFileVersion
     * @return \StructType\RegisterWorkRequest
     */
    public function setAuditFileVersion($auditFileVersion = null)
    {
        // validation for constraint: string
        if (!is_null($auditFileVersion) && !is_string($auditFileVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditFileVersion, true), gettype($auditFileVersion)), __LINE__);
        }
        // validation for constraint: pattern(1\.04_01|1\.03_01|1\.02_01|1\.01_01|1\.00_01|inexistente)
        if (!is_null($auditFileVersion) && !preg_match('/1\\.04_01|1\\.03_01|1\\.02_01|1\\.01_01|1\\.00_01|inexistente/', $auditFileVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 1\.04_01|1\.03_01|1\.02_01|1\.01_01|1\.00_01|inexistente', var_export($auditFileVersion, true)), __LINE__);
        }
        $this->AuditFileVersion = $auditFileVersion;
        return $this;
    }
    /**
     * Get TaxRegistrationNumber value
     * @return int|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->TaxRegistrationNumber;
    }
    /**
     * Set TaxRegistrationNumber value
     * @param int $taxRegistrationNumber
     * @return \StructType\RegisterWorkRequest
     */
    public function setTaxRegistrationNumber($taxRegistrationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($taxRegistrationNumber) && !(is_int($taxRegistrationNumber) || ctype_digit($taxRegistrationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxRegistrationNumber, true), gettype($taxRegistrationNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(100000000)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber < 100000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 100000000', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        $this->TaxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Get TaxEntity value
     * @return string|null
     */
    public function getTaxEntity()
    {
        return $this->TaxEntity;
    }
    /**
     * Set TaxEntity value
     * @param string $taxEntity
     * @return \StructType\RegisterWorkRequest
     */
    public function setTaxEntity($taxEntity = null)
    {
        // validation for constraint: string
        if (!is_null($taxEntity) && !is_string($taxEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxEntity, true), gettype($taxEntity)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($taxEntity) && mb_strlen($taxEntity) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($taxEntity)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxEntity) && mb_strlen($taxEntity) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxEntity)), __LINE__);
        }
        $this->TaxEntity = $taxEntity;
        return $this;
    }
    /**
     * Get SoftwareCertificateNumber value
     * @return int|null
     */
    public function getSoftwareCertificateNumber()
    {
        return $this->SoftwareCertificateNumber;
    }
    /**
     * Set SoftwareCertificateNumber value
     * @param int $softwareCertificateNumber
     * @return \StructType\RegisterWorkRequest
     */
    public function setSoftwareCertificateNumber($softwareCertificateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($softwareCertificateNumber) && !(is_int($softwareCertificateNumber) || ctype_digit($softwareCertificateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($softwareCertificateNumber, true), gettype($softwareCertificateNumber)), __LINE__);
        }
        $this->SoftwareCertificateNumber = $softwareCertificateNumber;
        return $this;
    }
    /**
     * Get WorkData value
     * @return \StructType\WorkDataType|null
     */
    public function getWorkData()
    {
        return $this->WorkData;
    }
    /**
     * Set WorkData value
     * @param \StructType\WorkDataType $workData
     * @return \StructType\RegisterWorkRequest
     */
    public function setWorkData(\StructType\WorkDataType $workData = null)
    {
        $this->WorkData = $workData;
        return $this;
    }
    /**
     * Get CanalRegisto value
     * @return \StructType\ChannelType|null
     */
    public function getCanalRegisto()
    {
        return $this->CanalRegisto;
    }
    /**
     * Set CanalRegisto value
     * @param \StructType\ChannelType $canalRegisto
     * @return \StructType\RegisterWorkRequest
     */
    public function setCanalRegisto(\StructType\ChannelType $canalRegisto = null)
    {
        $this->CanalRegisto = $canalRegisto;
        return $this;
    }
}
