<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReferences StructType
 * Meta information extracted from the WSDL
 * - type: tns:OrderReferences
 * @subpackage Structs
 */
class OrderReferences extends AbstractStructBase
{
    /**
     * The OriginatingON
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * - ref: tns:OriginatingON
     * @var string
     */
    public $OriginatingON;
    /**
     * The OrderDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OrderDate;
    /**
     * Constructor method for OrderReferences
     * @uses OrderReferences::setOriginatingON()
     * @uses OrderReferences::setOrderDate()
     * @param string $originatingON
     * @param string $orderDate
     */
    public function __construct($originatingON = null, $orderDate = null)
    {
        $this
            ->setOriginatingON($originatingON)
            ->setOrderDate($orderDate);
    }
    /**
     * Get OriginatingON value
     * @return string|null
     */
    public function getOriginatingON()
    {
        return $this->OriginatingON;
    }
    /**
     * Set OriginatingON value
     * @param string $originatingON
     * @return \StructType\OrderReferences
     */
    public function setOriginatingON($originatingON = null)
    {
        // validation for constraint: string
        if (!is_null($originatingON) && !is_string($originatingON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatingON, true), gettype($originatingON)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($originatingON) && mb_strlen($originatingON) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($originatingON)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originatingON) && mb_strlen($originatingON) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originatingON)), __LINE__);
        }
        $this->OriginatingON = $originatingON;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \StructType\OrderReferences
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
}
