<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListWorkDocumentsType StructType
 * @subpackage Structs
 */
class ListWorkDocumentsType extends AbstractStructBase
{
    /**
     * The work
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\WorkHeaderType[]
     */
    public $work;
    /**
     * Constructor method for ListWorkDocumentsType
     * @uses ListWorkDocumentsType::setWork()
     * @param \StructType\WorkHeaderType[] $work
     */
    public function __construct(array $work = array())
    {
        $this
            ->setWork($work);
    }
    /**
     * Get work value
     * @return \StructType\WorkHeaderType[]
     */
    public function getWork()
    {
        return $this->work;
    }
    /**
     * This method is responsible for validating the values passed to the setWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorkForArrayConstraintsFromSetWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listWorkDocumentsTypeWorkItem) {
            // validation for constraint: itemType
            if (!$listWorkDocumentsTypeWorkItem instanceof \StructType\WorkHeaderType) {
                $invalidValues[] = is_object($listWorkDocumentsTypeWorkItem) ? get_class($listWorkDocumentsTypeWorkItem) : sprintf('%s(%s)', gettype($listWorkDocumentsTypeWorkItem), var_export($listWorkDocumentsTypeWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The work property can only contain items of type \StructType\WorkHeaderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set work value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkHeaderType[] $work
     * @return \StructType\ListWorkDocumentsType
     */
    public function setWork(array $work = array())
    {
        // validation for constraint: array
        if ('' !== ($workArrayErrorMessage = self::validateWorkForArrayConstraintsFromSetWork($work))) {
            throw new \InvalidArgumentException($workArrayErrorMessage, __LINE__);
        }
        $this->work = $work;
        return $this;
    }
    /**
     * Add item to work value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkHeaderType $item
     * @return \StructType\ListWorkDocumentsType
     */
    public function addToWork(\StructType\WorkHeaderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkHeaderType) {
            throw new \InvalidArgumentException(sprintf('The work property can only contain items of type \StructType\WorkHeaderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->work[] = $item;
        return $this;
    }
}
