<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TaxType EnumType
 * @subpackage Enumerations
 */
class TaxType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'IVA'
     * @return string 'IVA'
     */
    const VALUE_IVA = 'IVA';
    /**
     * Constant for value 'IS'
     * @return string 'IS'
     */
    const VALUE_IS = 'IS';
    /**
     * Constant for value 'NS'
     * @return string 'NS'
     */
    const VALUE_NS = 'NS';
    /**
     * Return allowed values
     * @uses self::VALUE_IVA
     * @uses self::VALUE_IS
     * @uses self::VALUE_NS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IVA,
            self::VALUE_IS,
            self::VALUE_NS,
        );
    }
}
