<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceDocumentID StructType
 * Meta information extracted from the WSDL
 * - type: tns:SourceDocumentID
 * @subpackage Structs
 */
class SourceDocumentID extends AbstractStructBase
{
    /**
     * The OriginatingON
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minLength: 1
     * - ref: tns:OriginatingON
     * @var string
     */
    public $OriginatingON;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - ref: tns:InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * Constructor method for SourceDocumentID
     * @uses SourceDocumentID::setOriginatingON()
     * @uses SourceDocumentID::setInvoiceDate()
     * @param string $originatingON
     * @param string $invoiceDate
     */
    public function __construct($originatingON = null, $invoiceDate = null)
    {
        $this
            ->setOriginatingON($originatingON)
            ->setInvoiceDate($invoiceDate);
    }
    /**
     * Get OriginatingON value
     * @return string|null
     */
    public function getOriginatingON()
    {
        return $this->OriginatingON;
    }
    /**
     * Set OriginatingON value
     * @param string $originatingON
     * @return \StructType\SourceDocumentID
     */
    public function setOriginatingON($originatingON = null)
    {
        // validation for constraint: string
        if (!is_null($originatingON) && !is_string($originatingON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatingON, true), gettype($originatingON)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($originatingON) && mb_strlen($originatingON) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($originatingON)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($originatingON) && mb_strlen($originatingON) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($originatingON)), __LINE__);
        }
        $this->OriginatingON = $originatingON;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\SourceDocumentID
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
}
