<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceHeaderType StructType
 * @subpackage Structs
 */
class InvoiceHeaderType extends AbstractStructBase
{
    /**
     * The InvoiceNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minLength: 1
     * - pattern: [^ ]+ [^/^ ]+/[0-9]+
     * - ref: tns:InvoiceNo
     * @var string
     */
    public $InvoiceNo;
    /**
     * The ATCUD
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - minLength: 1
     * - ref: tns:ATCUD
     * @var string
     */
    public $ATCUD;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - ref: tns:InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - ref: tns:InvoiceType
     * @var string
     */
    public $InvoiceType;
    /**
     * The SelfBillingIndicator
     * @var string
     */
    public $SelfBillingIndicator;
    /**
     * The CustomerTaxID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - minLength: 1
     * - ref: tns:CustomerTaxID
     * @var string
     */
    public $CustomerTaxID;
    /**
     * The CustomerTaxIDCountry
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: [A-Z]{2}|Desconhecido
     * - ref: tns:CustomerTaxIDCountry
     * @var string
     */
    public $CustomerTaxIDCountry;
    /**
     * Constructor method for InvoiceHeaderType
     * @uses InvoiceHeaderType::setInvoiceNo()
     * @uses InvoiceHeaderType::setATCUD()
     * @uses InvoiceHeaderType::setInvoiceDate()
     * @uses InvoiceHeaderType::setInvoiceType()
     * @uses InvoiceHeaderType::setSelfBillingIndicator()
     * @uses InvoiceHeaderType::setCustomerTaxID()
     * @uses InvoiceHeaderType::setCustomerTaxIDCountry()
     * @param string $invoiceNo
     * @param string $aTCUD
     * @param string $invoiceDate
     * @param string $invoiceType
     * @param string $selfBillingIndicator
     * @param string $customerTaxID
     * @param string $customerTaxIDCountry
     */
    public function __construct($invoiceNo = null, $aTCUD = null, $invoiceDate = null, $invoiceType = null, $selfBillingIndicator = null, $customerTaxID = null, $customerTaxIDCountry = null)
    {
        $this
            ->setInvoiceNo($invoiceNo)
            ->setATCUD($aTCUD)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceType($invoiceType)
            ->setSelfBillingIndicator($selfBillingIndicator)
            ->setCustomerTaxID($customerTaxID)
            ->setCustomerTaxIDCountry($customerTaxIDCountry);
    }
    /**
     * Get InvoiceNo value
     * @return string|null
     */
    public function getInvoiceNo()
    {
        return $this->InvoiceNo;
    }
    /**
     * Set InvoiceNo value
     * @param string $invoiceNo
     * @return \StructType\InvoiceHeaderType
     */
    public function setInvoiceNo($invoiceNo = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNo) && !is_string($invoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNo, true), gettype($invoiceNo)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($invoiceNo) && mb_strlen($invoiceNo) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($invoiceNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invoiceNo) && mb_strlen($invoiceNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invoiceNo)), __LINE__);
        }
        // validation for constraint: pattern([^ ]+ [^/^ ]+/[0-9]+)
        if (!is_null($invoiceNo) && !preg_match('/[^ ]+ [^\/^ ]+\/[0-9]+/', $invoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^ ]+ [^/^ ]+/[0-9]+', var_export($invoiceNo, true)), __LINE__);
        }
        $this->InvoiceNo = $invoiceNo;
        return $this;
    }
    /**
     * Get ATCUD value
     * @return string|null
     */
    public function getATCUD()
    {
        return $this->ATCUD;
    }
    /**
     * Set ATCUD value
     * @param string $aTCUD
     * @return \StructType\InvoiceHeaderType
     */
    public function setATCUD($aTCUD = null)
    {
        // validation for constraint: string
        if (!is_null($aTCUD) && !is_string($aTCUD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTCUD, true), gettype($aTCUD)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($aTCUD) && mb_strlen($aTCUD) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($aTCUD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aTCUD) && mb_strlen($aTCUD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aTCUD)), __LINE__);
        }
        $this->ATCUD = $aTCUD;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\InvoiceHeaderType
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @uses \EnumType\InvoiceTypeType::valueIsValid()
     * @uses \EnumType\InvoiceTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceType
     * @return \StructType\InvoiceHeaderType
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InvoiceTypeType::valueIsValid($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InvoiceTypeType', is_array($invoiceType) ? implode(', ', $invoiceType) : var_export($invoiceType, true), implode(', ', \EnumType\InvoiceTypeType::getValidValues())), __LINE__);
        }
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get SelfBillingIndicator value
     * @return string|null
     */
    public function getSelfBillingIndicator()
    {
        return $this->SelfBillingIndicator;
    }
    /**
     * Set SelfBillingIndicator value
     * @uses \EnumType\SelfBillingIndicator::valueIsValid()
     * @uses \EnumType\SelfBillingIndicator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selfBillingIndicator
     * @return \StructType\InvoiceHeaderType
     */
    public function setSelfBillingIndicator($selfBillingIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SelfBillingIndicator::valueIsValid($selfBillingIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SelfBillingIndicator', is_array($selfBillingIndicator) ? implode(', ', $selfBillingIndicator) : var_export($selfBillingIndicator, true), implode(', ', \EnumType\SelfBillingIndicator::getValidValues())), __LINE__);
        }
        $this->SelfBillingIndicator = $selfBillingIndicator;
        return $this;
    }
    /**
     * Get CustomerTaxID value
     * @return string|null
     */
    public function getCustomerTaxID()
    {
        return $this->CustomerTaxID;
    }
    /**
     * Set CustomerTaxID value
     * @param string $customerTaxID
     * @return \StructType\InvoiceHeaderType
     */
    public function setCustomerTaxID($customerTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($customerTaxID) && !is_string($customerTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTaxID, true), gettype($customerTaxID)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($customerTaxID) && mb_strlen($customerTaxID) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($customerTaxID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerTaxID) && mb_strlen($customerTaxID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerTaxID)), __LINE__);
        }
        $this->CustomerTaxID = $customerTaxID;
        return $this;
    }
    /**
     * Get CustomerTaxIDCountry value
     * @return string|null
     */
    public function getCustomerTaxIDCountry()
    {
        return $this->CustomerTaxIDCountry;
    }
    /**
     * Set CustomerTaxIDCountry value
     * @param string $customerTaxIDCountry
     * @return \StructType\InvoiceHeaderType
     */
    public function setCustomerTaxIDCountry($customerTaxIDCountry = null)
    {
        // validation for constraint: string
        if (!is_null($customerTaxIDCountry) && !is_string($customerTaxIDCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTaxIDCountry, true), gettype($customerTaxIDCountry)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}|Desconhecido)
        if (!is_null($customerTaxIDCountry) && !preg_match('/[A-Z]{2}|Desconhecido/', $customerTaxIDCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}|Desconhecido', var_export($customerTaxIDCountry, true)), __LINE__);
        }
        $this->CustomerTaxIDCountry = $customerTaxIDCountry;
        return $this;
    }
}
