<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletePaymentRequest StructType
 * @subpackage Structs
 */
class DeletePaymentRequest extends AbstractStructBase
{
    /**
     * The eFaturaMDVersion
     * Meta information extracted from the WSDL
     * - documentation: Versao do webservice.
     * - base: string
     * - pattern: 0.0.1
     * - type: tns:eFaturaMDVersion
     * @var string
     */
    public $eFaturaMDVersion;
    /**
     * The TaxRegistrationNumber
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxInclusive: 999999999
     * - minInclusive: 100000000
     * - ref: tns:TaxRegistrationNumber
     * @var int
     */
    public $TaxRegistrationNumber;
    /**
     * The documentsList
     * Meta information extracted from the WSDL
     * - choice: documentsList | dateRange
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ListPaymentDocumentsType
     */
    public $documentsList;
    /**
     * The dateRange
     * Meta information extracted from the WSDL
     * - choice: documentsList | dateRange
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\DateRangeType
     */
    public $dateRange;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 500
     * - minLength: 10
     * @var string
     */
    public $reason;
    /**
     * The CanalRegisto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChannelType
     */
    public $CanalRegisto;
    /**
     * Constructor method for DeletePaymentRequest
     * @uses DeletePaymentRequest::setEFaturaMDVersion()
     * @uses DeletePaymentRequest::setTaxRegistrationNumber()
     * @uses DeletePaymentRequest::setDocumentsList()
     * @uses DeletePaymentRequest::setDateRange()
     * @uses DeletePaymentRequest::setReason()
     * @uses DeletePaymentRequest::setCanalRegisto()
     * @param string $eFaturaMDVersion
     * @param int $taxRegistrationNumber
     * @param \StructType\ListPaymentDocumentsType $documentsList
     * @param \StructType\DateRangeType $dateRange
     * @param string $reason
     * @param \StructType\ChannelType $canalRegisto
     */
    public function __construct($eFaturaMDVersion = null, $taxRegistrationNumber = null, \StructType\ListPaymentDocumentsType $documentsList = null, \StructType\DateRangeType $dateRange = null, $reason = null, \StructType\ChannelType $canalRegisto = null)
    {
        $this
            ->setEFaturaMDVersion($eFaturaMDVersion)
            ->setTaxRegistrationNumber($taxRegistrationNumber)
            ->setDocumentsList($documentsList)
            ->setDateRange($dateRange)
            ->setReason($reason)
            ->setCanalRegisto($canalRegisto);
    }
    /**
     * Get eFaturaMDVersion value
     * @return string|null
     */
    public function getEFaturaMDVersion()
    {
        return $this->eFaturaMDVersion;
    }
    /**
     * Set eFaturaMDVersion value
     * @param string $eFaturaMDVersion
     * @return \StructType\DeletePaymentRequest
     */
    public function setEFaturaMDVersion($eFaturaMDVersion = null)
    {
        // validation for constraint: string
        if (!is_null($eFaturaMDVersion) && !is_string($eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eFaturaMDVersion, true), gettype($eFaturaMDVersion)), __LINE__);
        }
        // validation for constraint: pattern(0.0.1)
        if (!is_null($eFaturaMDVersion) && !preg_match('/0.0.1/', $eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 0.0.1', var_export($eFaturaMDVersion, true)), __LINE__);
        }
        $this->eFaturaMDVersion = $eFaturaMDVersion;
        return $this;
    }
    /**
     * Get TaxRegistrationNumber value
     * @return int|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->TaxRegistrationNumber;
    }
    /**
     * Set TaxRegistrationNumber value
     * @param int $taxRegistrationNumber
     * @return \StructType\DeletePaymentRequest
     */
    public function setTaxRegistrationNumber($taxRegistrationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($taxRegistrationNumber) && !(is_int($taxRegistrationNumber) || ctype_digit($taxRegistrationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxRegistrationNumber, true), gettype($taxRegistrationNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(100000000)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber < 100000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 100000000', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        $this->TaxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Get documentsList value
     * @return \StructType\ListPaymentDocumentsType|null
     */
    public function getDocumentsList()
    {
        return isset($this->documentsList) ? $this->documentsList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDocumentsList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentsList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDocumentsListForChoiceConstraintsFromSetDocumentsList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'dateRange',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property documentsList can\'t be set as the property %s is already set. Only one property must be set among these properties: documentsList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set documentsList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ListPaymentDocumentsType $documentsList
     * @return \StructType\DeletePaymentRequest
     */
    public function setDocumentsList(\StructType\ListPaymentDocumentsType $documentsList = null)
    {
        // validation for constraint: choice(documentsList, dateRange)
        if ('' !== ($documentsListChoiceErrorMessage = self::validateDocumentsListForChoiceConstraintsFromSetDocumentsList($documentsList))) {
            throw new \InvalidArgumentException($documentsListChoiceErrorMessage, __LINE__);
        }
        if (is_null($documentsList) || (is_array($documentsList) && empty($documentsList))) {
            unset($this->documentsList);
        } else {
            $this->documentsList = $documentsList;
        }
        return $this;
    }
    /**
     * Get dateRange value
     * @return \StructType\DateRangeType|null
     */
    public function getDateRange()
    {
        return isset($this->dateRange) ? $this->dateRange : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateRange method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateRangeForChoiceConstraintsFromSetDateRange($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'documentsList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dateRange can\'t be set as the property %s is already set. Only one property must be set among these properties: dateRange, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dateRange value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DateRangeType $dateRange
     * @return \StructType\DeletePaymentRequest
     */
    public function setDateRange(\StructType\DateRangeType $dateRange = null)
    {
        // validation for constraint: choice(documentsList, dateRange)
        if ('' !== ($dateRangeChoiceErrorMessage = self::validateDateRangeForChoiceConstraintsFromSetDateRange($dateRange))) {
            throw new \InvalidArgumentException($dateRangeChoiceErrorMessage, __LINE__);
        }
        if (is_null($dateRange) || (is_array($dateRange) && empty($dateRange))) {
            unset($this->dateRange);
        } else {
            $this->dateRange = $dateRange;
        }
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\DeletePaymentRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($reason) && mb_strlen($reason) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($reason)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($reason) && mb_strlen($reason) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get CanalRegisto value
     * @return \StructType\ChannelType|null
     */
    public function getCanalRegisto()
    {
        return $this->CanalRegisto;
    }
    /**
     * Set CanalRegisto value
     * @param \StructType\ChannelType $canalRegisto
     * @return \StructType\DeletePaymentRequest
     */
    public function setCanalRegisto(\StructType\ChannelType $canalRegisto = null)
    {
        $this->CanalRegisto = $canalRegisto;
        return $this;
    }
}
