<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteInvoiceRequest $deleteInvoiceRequest
     * @return \StructType\DeleteInvoiceResponse|bool
     */
    public function DeleteInvoice(\StructType\DeleteInvoiceRequest $deleteInvoiceRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteInvoice($deleteInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteWork
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteWorkRequest $deleteWorkRequest
     * @return \StructType\DeleteWorkResponse|bool
     */
    public function DeleteWork(\StructType\DeleteWorkRequest $deleteWorkRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteWork($deleteWorkRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeletePaymentRequest $deletePaymentRequest
     * @return \StructType\DeletePaymentResponse|bool
     */
    public function DeletePayment(\StructType\DeletePaymentRequest $deletePaymentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePayment($deletePaymentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteInvoiceResponse|\StructType\DeletePaymentResponse|\StructType\DeleteWorkResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
