<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDataType StructType
 * @subpackage Structs
 */
class PaymentDataType extends PaymentHeaderType
{
    /**
     * The DocumentStatus
     * @var \StructType\PaymentStatus
     */
    public $DocumentStatus;
    /**
     * The SystemEntryDate
     * Meta information extracted from the WSDL
     * - ref: tns:SystemEntryDate
     * @var string
     */
    public $SystemEntryDate;
    /**
     * The LineSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LineSummary[]
     */
    public $LineSummary;
    /**
     * The DocumentTotals
     * @var \StructType\DocumentTotals
     */
    public $DocumentTotals;
    /**
     * The WithholdingTax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WithholdingTax[]
     */
    public $WithholdingTax;
    /**
     * Constructor method for PaymentDataType
     * @uses PaymentDataType::setDocumentStatus()
     * @uses PaymentDataType::setSystemEntryDate()
     * @uses PaymentDataType::setLineSummary()
     * @uses PaymentDataType::setDocumentTotals()
     * @uses PaymentDataType::setWithholdingTax()
     * @param \StructType\PaymentStatus $documentStatus
     * @param string $systemEntryDate
     * @param \StructType\LineSummary[] $lineSummary
     * @param \StructType\DocumentTotals $documentTotals
     * @param \StructType\WithholdingTax[] $withholdingTax
     */
    public function __construct(\StructType\PaymentStatus $documentStatus = null, $systemEntryDate = null, array $lineSummary = array(), \StructType\DocumentTotals $documentTotals = null, array $withholdingTax = array())
    {
        $this
            ->setDocumentStatus($documentStatus)
            ->setSystemEntryDate($systemEntryDate)
            ->setLineSummary($lineSummary)
            ->setDocumentTotals($documentTotals)
            ->setWithholdingTax($withholdingTax);
    }
    /**
     * Get DocumentStatus value
     * @return \StructType\PaymentStatus|null
     */
    public function getDocumentStatus()
    {
        return $this->DocumentStatus;
    }
    /**
     * Set DocumentStatus value
     * @param \StructType\PaymentStatus $documentStatus
     * @return \StructType\PaymentDataType
     */
    public function setDocumentStatus(\StructType\PaymentStatus $documentStatus = null)
    {
        $this->DocumentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get SystemEntryDate value
     * @return string|null
     */
    public function getSystemEntryDate()
    {
        return $this->SystemEntryDate;
    }
    /**
     * Set SystemEntryDate value
     * @param string $systemEntryDate
     * @return \StructType\PaymentDataType
     */
    public function setSystemEntryDate($systemEntryDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemEntryDate) && !is_string($systemEntryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemEntryDate, true), gettype($systemEntryDate)), __LINE__);
        }
        $this->SystemEntryDate = $systemEntryDate;
        return $this;
    }
    /**
     * Get LineSummary value
     * @return \StructType\LineSummary[]|null
     */
    public function getLineSummary()
    {
        return $this->LineSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setLineSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineSummaryForArrayConstraintsFromSetLineSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentDataTypeLineSummaryItem) {
            // validation for constraint: itemType
            if (!$paymentDataTypeLineSummaryItem instanceof \StructType\LineSummary) {
                $invalidValues[] = is_object($paymentDataTypeLineSummaryItem) ? get_class($paymentDataTypeLineSummaryItem) : sprintf('%s(%s)', gettype($paymentDataTypeLineSummaryItem), var_export($paymentDataTypeLineSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineSummary property can only contain items of type \StructType\LineSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSummary[] $lineSummary
     * @return \StructType\PaymentDataType
     */
    public function setLineSummary(array $lineSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($lineSummaryArrayErrorMessage = self::validateLineSummaryForArrayConstraintsFromSetLineSummary($lineSummary))) {
            throw new \InvalidArgumentException($lineSummaryArrayErrorMessage, __LINE__);
        }
        $this->LineSummary = $lineSummary;
        return $this;
    }
    /**
     * Add item to LineSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSummary $item
     * @return \StructType\PaymentDataType
     */
    public function addToLineSummary(\StructType\LineSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineSummary) {
            throw new \InvalidArgumentException(sprintf('The LineSummary property can only contain items of type \StructType\LineSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineSummary[] = $item;
        return $this;
    }
    /**
     * Get DocumentTotals value
     * @return \StructType\DocumentTotals|null
     */
    public function getDocumentTotals()
    {
        return $this->DocumentTotals;
    }
    /**
     * Set DocumentTotals value
     * @param \StructType\DocumentTotals $documentTotals
     * @return \StructType\PaymentDataType
     */
    public function setDocumentTotals(\StructType\DocumentTotals $documentTotals = null)
    {
        $this->DocumentTotals = $documentTotals;
        return $this;
    }
    /**
     * Get WithholdingTax value
     * @return \StructType\WithholdingTax[]|null
     */
    public function getWithholdingTax()
    {
        return $this->WithholdingTax;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholdingTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxForArrayConstraintsFromSetWithholdingTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentDataTypeWithholdingTaxItem) {
            // validation for constraint: itemType
            if (!$paymentDataTypeWithholdingTaxItem instanceof \StructType\WithholdingTax) {
                $invalidValues[] = is_object($paymentDataTypeWithholdingTaxItem) ? get_class($paymentDataTypeWithholdingTaxItem) : sprintf('%s(%s)', gettype($paymentDataTypeWithholdingTaxItem), var_export($paymentDataTypeWithholdingTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTax property can only contain items of type \StructType\WithholdingTax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithholdingTax value
     * @throws \InvalidArgumentException
     * @param \StructType\WithholdingTax[] $withholdingTax
     * @return \StructType\PaymentDataType
     */
    public function setWithholdingTax(array $withholdingTax = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxArrayErrorMessage = self::validateWithholdingTaxForArrayConstraintsFromSetWithholdingTax($withholdingTax))) {
            throw new \InvalidArgumentException($withholdingTaxArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTax = $withholdingTax;
        return $this;
    }
    /**
     * Add item to WithholdingTax value
     * @throws \InvalidArgumentException
     * @param \StructType\WithholdingTax $item
     * @return \StructType\PaymentDataType
     */
    public function addToWithholdingTax(\StructType\WithholdingTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WithholdingTax) {
            throw new \InvalidArgumentException(sprintf('The WithholdingTax property can only contain items of type \StructType\WithholdingTax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTax[] = $item;
        return $this;
    }
}
