<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewPaymentStatusType StructType
 * @subpackage Structs
 */
class NewPaymentStatusType extends AbstractStructBase
{
    /**
     * The PaymentStatus
     * @var \StructType\PaymentStatus
     */
    public $PaymentStatus;
    /**
     * The PaymentStatusDate
     * @var string
     */
    public $PaymentStatusDate;
    /**
     * Constructor method for NewPaymentStatusType
     * @uses NewPaymentStatusType::setPaymentStatus()
     * @uses NewPaymentStatusType::setPaymentStatusDate()
     * @param \StructType\PaymentStatus $paymentStatus
     * @param string $paymentStatusDate
     */
    public function __construct(\StructType\PaymentStatus $paymentStatus = null, $paymentStatusDate = null)
    {
        $this
            ->setPaymentStatus($paymentStatus)
            ->setPaymentStatusDate($paymentStatusDate);
    }
    /**
     * Get PaymentStatus value
     * @return \StructType\PaymentStatus|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @param \StructType\PaymentStatus $paymentStatus
     * @return \StructType\NewPaymentStatusType
     */
    public function setPaymentStatus(\StructType\PaymentStatus $paymentStatus = null)
    {
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get PaymentStatusDate value
     * @return string|null
     */
    public function getPaymentStatusDate()
    {
        return $this->PaymentStatusDate;
    }
    /**
     * Set PaymentStatusDate value
     * @param string $paymentStatusDate
     * @return \StructType\NewPaymentStatusType
     */
    public function setPaymentStatusDate($paymentStatusDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusDate) && !is_string($paymentStatusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusDate, true), gettype($paymentStatusDate)), __LINE__);
        }
        $this->PaymentStatusDate = $paymentStatusDate;
        return $this;
    }
}
