<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListPaymentDocumentsType StructType
 * @subpackage Structs
 */
class ListPaymentDocumentsType extends AbstractStructBase
{
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PaymentHeaderType[]
     */
    public $payment;
    /**
     * Constructor method for ListPaymentDocumentsType
     * @uses ListPaymentDocumentsType::setPayment()
     * @param \StructType\PaymentHeaderType[] $payment
     */
    public function __construct(array $payment = array())
    {
        $this
            ->setPayment($payment);
    }
    /**
     * Get payment value
     * @return \StructType\PaymentHeaderType[]
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentForArrayConstraintsFromSetPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listPaymentDocumentsTypePaymentItem) {
            // validation for constraint: itemType
            if (!$listPaymentDocumentsTypePaymentItem instanceof \StructType\PaymentHeaderType) {
                $invalidValues[] = is_object($listPaymentDocumentsTypePaymentItem) ? get_class($listPaymentDocumentsTypePaymentItem) : sprintf('%s(%s)', gettype($listPaymentDocumentsTypePaymentItem), var_export($listPaymentDocumentsTypePaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payment property can only contain items of type \StructType\PaymentHeaderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentHeaderType[] $payment
     * @return \StructType\ListPaymentDocumentsType
     */
    public function setPayment(array $payment = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentArrayErrorMessage = self::validatePaymentForArrayConstraintsFromSetPayment($payment))) {
            throw new \InvalidArgumentException($paymentArrayErrorMessage, __LINE__);
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentHeaderType $item
     * @return \StructType\ListPaymentDocumentsType
     */
    public function addToPayment(\StructType\PaymentHeaderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentHeaderType) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of type \StructType\PaymentHeaderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
}
