<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineSummary StructType
 * @subpackage Structs
 */
class LineSummary extends AbstractStructBase
{
    /**
     * The OrderReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:OrderReferences
     * @var \StructType\OrderReferences[]
     */
    public $OrderReferences;
    /**
     * The TaxPointDate
     * Meta information extracted from the WSDL
     * - ref: tns:TaxPointDate
     * @var string
     */
    public $TaxPointDate;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: unbounded
     * - minLength: 1
     * - minOccurs: 0
     * - ref: tns:Reference
     * @var string[]
     */
    public $Reference;
    /**
     * The DebitCreditIndicator
     * Meta information extracted from the WSDL
     * - ref: tns:DebitCreditIndicator
     * @var string
     */
    public $DebitCreditIndicator;
    /**
     * The TotalTaxBase
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - choice: TotalTaxBase | Amount | TotalTaxBase | Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * - ref: tns:TotalTaxBase
     * @var float
     */
    public $TotalTaxBase;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - choice: TotalTaxBase | Amount | TotalTaxBase | Amount | Amount
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * - ref: tns:Amount
     * @var float
     */
    public $Amount;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Tax
     * @var \StructType\Tax
     */
    public $Tax;
    /**
     * The TaxExemptionCode
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: (M[0-9]{2})+
     * - ref: tns:TaxExemptionCode
     * - type: tns:TaxExemptionCode
     * @var string
     */
    public $TaxExemptionCode;
    /**
     * The SourceDocumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:SourceDocumentID
     * @var \StructType\SourceDocumentID[]
     */
    public $SourceDocumentID;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - documentation: Elemento do SAF-T alterado, com a inclusão do valor máximo permitido.
     * - base: decimal
     * - maxInclusive: 9999999999999.99
     * - minInclusive: 0.00
     * - minOccurs: 0
     * @var float
     */
    public $SettlementAmount;
    /**
     * Constructor method for LineSummary
     * @uses LineSummary::setOrderReferences()
     * @uses LineSummary::setTaxPointDate()
     * @uses LineSummary::setReference()
     * @uses LineSummary::setDebitCreditIndicator()
     * @uses LineSummary::setTotalTaxBase()
     * @uses LineSummary::setAmount()
     * @uses LineSummary::setTax()
     * @uses LineSummary::setTaxExemptionCode()
     * @uses LineSummary::setSourceDocumentID()
     * @uses LineSummary::setSettlementAmount()
     * @param \StructType\OrderReferences[] $orderReferences
     * @param string $taxPointDate
     * @param string[] $reference
     * @param string $debitCreditIndicator
     * @param float $totalTaxBase
     * @param float $amount
     * @param \StructType\Tax $tax
     * @param string $taxExemptionCode
     * @param \StructType\SourceDocumentID[] $sourceDocumentID
     * @param float $settlementAmount
     */
    public function __construct(array $orderReferences = array(), $taxPointDate = null, array $reference = array(), $debitCreditIndicator = null, $totalTaxBase = null, $amount = null, \StructType\Tax $tax = null, $taxExemptionCode = null, array $sourceDocumentID = array(), $settlementAmount = null)
    {
        $this
            ->setOrderReferences($orderReferences)
            ->setTaxPointDate($taxPointDate)
            ->setReference($reference)
            ->setDebitCreditIndicator($debitCreditIndicator)
            ->setTotalTaxBase($totalTaxBase)
            ->setAmount($amount)
            ->setTax($tax)
            ->setTaxExemptionCode($taxExemptionCode)
            ->setSourceDocumentID($sourceDocumentID)
            ->setSettlementAmount($settlementAmount);
    }
    /**
     * Get OrderReferences value
     * @return \StructType\OrderReferences[]|null
     */
    public function getOrderReferences()
    {
        return $this->OrderReferences;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderReferences method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderReferencesForArrayConstraintsFromSetOrderReferences(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineSummaryOrderReferencesItem) {
            // validation for constraint: itemType
            if (!$lineSummaryOrderReferencesItem instanceof \StructType\OrderReferences) {
                $invalidValues[] = is_object($lineSummaryOrderReferencesItem) ? get_class($lineSummaryOrderReferencesItem) : sprintf('%s(%s)', gettype($lineSummaryOrderReferencesItem), var_export($lineSummaryOrderReferencesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderReferences property can only contain items of type \StructType\OrderReferences, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderReferences value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderReferences[] $orderReferences
     * @return \StructType\LineSummary
     */
    public function setOrderReferences(array $orderReferences = array())
    {
        // validation for constraint: array
        if ('' !== ($orderReferencesArrayErrorMessage = self::validateOrderReferencesForArrayConstraintsFromSetOrderReferences($orderReferences))) {
            throw new \InvalidArgumentException($orderReferencesArrayErrorMessage, __LINE__);
        }
        $this->OrderReferences = $orderReferences;
        return $this;
    }
    /**
     * Add item to OrderReferences value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderReferences $item
     * @return \StructType\LineSummary
     */
    public function addToOrderReferences(\StructType\OrderReferences $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderReferences) {
            throw new \InvalidArgumentException(sprintf('The OrderReferences property can only contain items of type \StructType\OrderReferences, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderReferences[] = $item;
        return $this;
    }
    /**
     * Get TaxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->TaxPointDate;
    }
    /**
     * Set TaxPointDate value
     * @param string $taxPointDate
     * @return \StructType\LineSummary
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->TaxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get Reference value
     * @return string[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForArrayConstraintsFromSetReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineSummaryReferenceItem) {
            // validation for constraint: itemType
            if (!is_string($lineSummaryReferenceItem)) {
                $invalidValues[] = is_object($lineSummaryReferenceItem) ? get_class($lineSummaryReferenceItem) : sprintf('%s(%s)', gettype($lineSummaryReferenceItem), var_export($lineSummaryReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reference property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForMaxLengthConstraintFromSetReference($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineSummaryReferenceItem) {
            // validation for constraint: maxLength(60)
            if (mb_strlen($lineSummaryReferenceItem) > 60) {
                $invalidValues[] = var_export($lineSummaryReferenceItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 60', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForMinLengthConstraintFromSetReference($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineSummaryReferenceItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($lineSummaryReferenceItem) < 1) {
                $invalidValues[] = var_export($lineSummaryReferenceItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param string[] $reference
     * @return \StructType\LineSummary
     */
    public function setReference(array $reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceArrayErrorMessage = self::validateReferenceForArrayConstraintsFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(60)
        if ('' !== ($referenceMaxLengthErrorMessage = self::validateReferenceForMaxLengthConstraintFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($referenceMinLengthErrorMessage = self::validateReferenceForMinLengthConstraintFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceMinLengthErrorMessage, __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LineSummary
     */
    public function addToReference($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (mb_strlen($item) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get DebitCreditIndicator value
     * @return string|null
     */
    public function getDebitCreditIndicator()
    {
        return $this->DebitCreditIndicator;
    }
    /**
     * Set DebitCreditIndicator value
     * @uses \EnumType\DebitCreditIndicator::valueIsValid()
     * @uses \EnumType\DebitCreditIndicator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debitCreditIndicator
     * @return \StructType\LineSummary
     */
    public function setDebitCreditIndicator($debitCreditIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DebitCreditIndicator::valueIsValid($debitCreditIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DebitCreditIndicator', is_array($debitCreditIndicator) ? implode(', ', $debitCreditIndicator) : var_export($debitCreditIndicator, true), implode(', ', \EnumType\DebitCreditIndicator::getValidValues())), __LINE__);
        }
        $this->DebitCreditIndicator = $debitCreditIndicator;
        return $this;
    }
    /**
     * Get TotalTaxBase value
     * @return float|null
     */
    public function getTotalTaxBase()
    {
        return isset($this->TotalTaxBase) ? $this->TotalTaxBase : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTotalTaxBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalTaxBase method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTotalTaxBaseForChoiceConstraintsFromSetTotalTaxBase($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Amount',
            'Amount',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TotalTaxBase can\'t be set as the property %s is already set. Only one property must be set among these properties: TotalTaxBase, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TotalTaxBase value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $totalTaxBase
     * @return \StructType\LineSummary
     */
    public function setTotalTaxBase($totalTaxBase = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxBase) && !(is_float($totalTaxBase) || is_numeric($totalTaxBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxBase, true), gettype($totalTaxBase)), __LINE__);
        }
        // validation for constraint: choice(TotalTaxBase, Amount, TotalTaxBase, Amount)
        if ('' !== ($totalTaxBaseChoiceErrorMessage = self::validateTotalTaxBaseForChoiceConstraintsFromSetTotalTaxBase($totalTaxBase))) {
            throw new \InvalidArgumentException($totalTaxBaseChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($totalTaxBase) && $totalTaxBase > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($totalTaxBase, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($totalTaxBase) && $totalTaxBase < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($totalTaxBase, true)), __LINE__);
        }
        if (is_null($totalTaxBase) || (is_array($totalTaxBase) && empty($totalTaxBase))) {
            unset($this->TotalTaxBase);
        } else {
            $this->TotalTaxBase = $totalTaxBase;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmountForChoiceConstraintsFromSetAmount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TotalTaxBase',
            'TotalTaxBase',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Amount can\'t be set as the property %s is already set. Only one property must be set among these properties: Amount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Amount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $amount
     * @return \StructType\LineSummary
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: choice(TotalTaxBase, Amount, TotalTaxBase, Amount, Amount)
        if ('' !== ($amountChoiceErrorMessage = self::validateAmountForChoiceConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($amount) && $amount > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($amount, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($amount) && $amount < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($amount, true)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\Tax|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param \StructType\Tax $tax
     * @return \StructType\LineSummary
     */
    public function setTax(\StructType\Tax $tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TaxExemptionCode value
     * @return string|null
     */
    public function getTaxExemptionCode()
    {
        return $this->TaxExemptionCode;
    }
    /**
     * Set TaxExemptionCode value
     * @param string $taxExemptionCode
     * @return \StructType\LineSummary
     */
    public function setTaxExemptionCode($taxExemptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptionCode) && !is_string($taxExemptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptionCode, true), gettype($taxExemptionCode)), __LINE__);
        }
        // validation for constraint: pattern((M[0-9]{2})+)
        if (!is_null($taxExemptionCode) && !preg_match('/(M[0-9]{2})+/', $taxExemptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (M[0-9]{2})+', var_export($taxExemptionCode, true)), __LINE__);
        }
        $this->TaxExemptionCode = $taxExemptionCode;
        return $this;
    }
    /**
     * Get SourceDocumentID value
     * @return \StructType\SourceDocumentID[]|null
     */
    public function getSourceDocumentID()
    {
        return $this->SourceDocumentID;
    }
    /**
     * This method is responsible for validating the values passed to the setSourceDocumentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSourceDocumentID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSourceDocumentIDForArrayConstraintsFromSetSourceDocumentID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineSummarySourceDocumentIDItem) {
            // validation for constraint: itemType
            if (!$lineSummarySourceDocumentIDItem instanceof \StructType\SourceDocumentID) {
                $invalidValues[] = is_object($lineSummarySourceDocumentIDItem) ? get_class($lineSummarySourceDocumentIDItem) : sprintf('%s(%s)', gettype($lineSummarySourceDocumentIDItem), var_export($lineSummarySourceDocumentIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SourceDocumentID property can only contain items of type \StructType\SourceDocumentID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SourceDocumentID value
     * @throws \InvalidArgumentException
     * @param \StructType\SourceDocumentID[] $sourceDocumentID
     * @return \StructType\LineSummary
     */
    public function setSourceDocumentID(array $sourceDocumentID = array())
    {
        // validation for constraint: array
        if ('' !== ($sourceDocumentIDArrayErrorMessage = self::validateSourceDocumentIDForArrayConstraintsFromSetSourceDocumentID($sourceDocumentID))) {
            throw new \InvalidArgumentException($sourceDocumentIDArrayErrorMessage, __LINE__);
        }
        $this->SourceDocumentID = $sourceDocumentID;
        return $this;
    }
    /**
     * Add item to SourceDocumentID value
     * @throws \InvalidArgumentException
     * @param \StructType\SourceDocumentID $item
     * @return \StructType\LineSummary
     */
    public function addToSourceDocumentID(\StructType\SourceDocumentID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SourceDocumentID) {
            throw new \InvalidArgumentException(sprintf('The SourceDocumentID property can only contain items of type \StructType\SourceDocumentID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SourceDocumentID[] = $item;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param float $settlementAmount
     * @return \StructType\LineSummary
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($settlementAmount) && !(is_float($settlementAmount) || is_numeric($settlementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($settlementAmount, true), gettype($settlementAmount)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999.99)
        if (!is_null($settlementAmount) && $settlementAmount > 9999999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999.99', var_export($settlementAmount, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($settlementAmount) && $settlementAmount < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($settlementAmount, true)), __LINE__);
        }
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
}
