<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDataType StructType
 * @subpackage Structs
 */
class InvoiceDataType extends InvoiceHeaderType
{
    /**
     * The DocumentStatus
     * @var \StructType\InvoiceStatus
     */
    public $DocumentStatus;
    /**
     * The HashCharacters
     * Meta information extracted from the WSDL
     * - base: string
     * - pattern: [0]|[^^]{4}
     * - ref: tns:HashCharacters
     * - type: tns:HashCharacters
     * @var string
     */
    public $HashCharacters;
    /**
     * The CashVATSchemeIndicator
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxInclusive: 1
     * - minInclusive: 0
     * - ref: tns:CashVATSchemeIndicator
     * - type: tns:CashVATSchemeIndicator
     * @var int
     */
    public $CashVATSchemeIndicator;
    /**
     * The PaperLessIndicator
     * Meta information extracted from the WSDL
     * - base: integer
     * - default: 0
     * - maxInclusive: 1
     * - minInclusive: 0
     * - ref: tns:PaperLessIndicator
     * - type: tns:PaperLessIndicator
     * @var int
     */
    public $PaperLessIndicator;
    /**
     * The EACCode
     * Meta information extracted from the WSDL
     * - base: string
     * - length: 5
     * - minOccurs: 0
     * - pattern: (([0-9]*))
     * - ref: tns:EACCode
     * - type: tns:EACCode
     * @var string
     */
    public $EACCode;
    /**
     * The SystemEntryDate
     * Meta information extracted from the WSDL
     * - ref: tns:SystemEntryDate
     * @var string
     */
    public $SystemEntryDate;
    /**
     * The LineSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LineSummary[]
     */
    public $LineSummary;
    /**
     * The DocumentTotals
     * @var \StructType\DocumentTotals
     */
    public $DocumentTotals;
    /**
     * The WithholdingTax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WithholdingTax[]
     */
    public $WithholdingTax;
    /**
     * Constructor method for InvoiceDataType
     * @uses InvoiceDataType::setDocumentStatus()
     * @uses InvoiceDataType::setHashCharacters()
     * @uses InvoiceDataType::setCashVATSchemeIndicator()
     * @uses InvoiceDataType::setPaperLessIndicator()
     * @uses InvoiceDataType::setEACCode()
     * @uses InvoiceDataType::setSystemEntryDate()
     * @uses InvoiceDataType::setLineSummary()
     * @uses InvoiceDataType::setDocumentTotals()
     * @uses InvoiceDataType::setWithholdingTax()
     * @param \StructType\InvoiceStatus $documentStatus
     * @param string $hashCharacters
     * @param int $cashVATSchemeIndicator
     * @param int $paperLessIndicator
     * @param string $eACCode
     * @param string $systemEntryDate
     * @param \StructType\LineSummary[] $lineSummary
     * @param \StructType\DocumentTotals $documentTotals
     * @param \StructType\WithholdingTax[] $withholdingTax
     */
    public function __construct(\StructType\InvoiceStatus $documentStatus = null, $hashCharacters = null, $cashVATSchemeIndicator = null, $paperLessIndicator = 0, $eACCode = null, $systemEntryDate = null, array $lineSummary = array(), \StructType\DocumentTotals $documentTotals = null, array $withholdingTax = array())
    {
        $this
            ->setDocumentStatus($documentStatus)
            ->setHashCharacters($hashCharacters)
            ->setCashVATSchemeIndicator($cashVATSchemeIndicator)
            ->setPaperLessIndicator($paperLessIndicator)
            ->setEACCode($eACCode)
            ->setSystemEntryDate($systemEntryDate)
            ->setLineSummary($lineSummary)
            ->setDocumentTotals($documentTotals)
            ->setWithholdingTax($withholdingTax);
    }
    /**
     * Get DocumentStatus value
     * @return \StructType\InvoiceStatus|null
     */
    public function getDocumentStatus()
    {
        return $this->DocumentStatus;
    }
    /**
     * Set DocumentStatus value
     * @param \StructType\InvoiceStatus $documentStatus
     * @return \StructType\InvoiceDataType
     */
    public function setDocumentStatus(\StructType\InvoiceStatus $documentStatus = null)
    {
        $this->DocumentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get HashCharacters value
     * @return string|null
     */
    public function getHashCharacters()
    {
        return $this->HashCharacters;
    }
    /**
     * Set HashCharacters value
     * @param string $hashCharacters
     * @return \StructType\InvoiceDataType
     */
    public function setHashCharacters($hashCharacters = null)
    {
        // validation for constraint: string
        if (!is_null($hashCharacters) && !is_string($hashCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashCharacters, true), gettype($hashCharacters)), __LINE__);
        }
        // validation for constraint: pattern([0]|[^^]{4})
        if (!is_null($hashCharacters) && !preg_match('/[0]|[^^]{4}/', $hashCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0]|[^^]{4}', var_export($hashCharacters, true)), __LINE__);
        }
        $this->HashCharacters = $hashCharacters;
        return $this;
    }
    /**
     * Get CashVATSchemeIndicator value
     * @return int|null
     */
    public function getCashVATSchemeIndicator()
    {
        return $this->CashVATSchemeIndicator;
    }
    /**
     * Set CashVATSchemeIndicator value
     * @param int $cashVATSchemeIndicator
     * @return \StructType\InvoiceDataType
     */
    public function setCashVATSchemeIndicator($cashVATSchemeIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($cashVATSchemeIndicator) && !(is_int($cashVATSchemeIndicator) || ctype_digit($cashVATSchemeIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cashVATSchemeIndicator, true), gettype($cashVATSchemeIndicator)), __LINE__);
        }
        // validation for constraint: maxInclusive(1)
        if (!is_null($cashVATSchemeIndicator) && $cashVATSchemeIndicator > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 1', var_export($cashVATSchemeIndicator, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cashVATSchemeIndicator) && $cashVATSchemeIndicator < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cashVATSchemeIndicator, true)), __LINE__);
        }
        $this->CashVATSchemeIndicator = $cashVATSchemeIndicator;
        return $this;
    }
    /**
     * Get PaperLessIndicator value
     * @return int|null
     */
    public function getPaperLessIndicator()
    {
        return $this->PaperLessIndicator;
    }
    /**
     * Set PaperLessIndicator value
     * @param int $paperLessIndicator
     * @return \StructType\InvoiceDataType
     */
    public function setPaperLessIndicator($paperLessIndicator = 0)
    {
        // validation for constraint: int
        if (!is_null($paperLessIndicator) && !(is_int($paperLessIndicator) || ctype_digit($paperLessIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paperLessIndicator, true), gettype($paperLessIndicator)), __LINE__);
        }
        // validation for constraint: maxInclusive(1)
        if (!is_null($paperLessIndicator) && $paperLessIndicator > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 1', var_export($paperLessIndicator, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($paperLessIndicator) && $paperLessIndicator < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($paperLessIndicator, true)), __LINE__);
        }
        $this->PaperLessIndicator = $paperLessIndicator;
        return $this;
    }
    /**
     * Get EACCode value
     * @return string|null
     */
    public function getEACCode()
    {
        return $this->EACCode;
    }
    /**
     * Set EACCode value
     * @param string $eACCode
     * @return \StructType\InvoiceDataType
     */
    public function setEACCode($eACCode = null)
    {
        // validation for constraint: string
        if (!is_null($eACCode) && !is_string($eACCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eACCode, true), gettype($eACCode)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($eACCode) && mb_strlen($eACCode) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($eACCode)), __LINE__);
        }
        // validation for constraint: pattern((([0-9]*)))
        if (!is_null($eACCode) && !preg_match('/(([0-9]*))/', $eACCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (([0-9]*))', var_export($eACCode, true)), __LINE__);
        }
        $this->EACCode = $eACCode;
        return $this;
    }
    /**
     * Get SystemEntryDate value
     * @return string|null
     */
    public function getSystemEntryDate()
    {
        return $this->SystemEntryDate;
    }
    /**
     * Set SystemEntryDate value
     * @param string $systemEntryDate
     * @return \StructType\InvoiceDataType
     */
    public function setSystemEntryDate($systemEntryDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemEntryDate) && !is_string($systemEntryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemEntryDate, true), gettype($systemEntryDate)), __LINE__);
        }
        $this->SystemEntryDate = $systemEntryDate;
        return $this;
    }
    /**
     * Get LineSummary value
     * @return \StructType\LineSummary[]|null
     */
    public function getLineSummary()
    {
        return $this->LineSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setLineSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineSummaryForArrayConstraintsFromSetLineSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceDataTypeLineSummaryItem) {
            // validation for constraint: itemType
            if (!$invoiceDataTypeLineSummaryItem instanceof \StructType\LineSummary) {
                $invalidValues[] = is_object($invoiceDataTypeLineSummaryItem) ? get_class($invoiceDataTypeLineSummaryItem) : sprintf('%s(%s)', gettype($invoiceDataTypeLineSummaryItem), var_export($invoiceDataTypeLineSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineSummary property can only contain items of type \StructType\LineSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSummary[] $lineSummary
     * @return \StructType\InvoiceDataType
     */
    public function setLineSummary(array $lineSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($lineSummaryArrayErrorMessage = self::validateLineSummaryForArrayConstraintsFromSetLineSummary($lineSummary))) {
            throw new \InvalidArgumentException($lineSummaryArrayErrorMessage, __LINE__);
        }
        $this->LineSummary = $lineSummary;
        return $this;
    }
    /**
     * Add item to LineSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSummary $item
     * @return \StructType\InvoiceDataType
     */
    public function addToLineSummary(\StructType\LineSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineSummary) {
            throw new \InvalidArgumentException(sprintf('The LineSummary property can only contain items of type \StructType\LineSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineSummary[] = $item;
        return $this;
    }
    /**
     * Get DocumentTotals value
     * @return \StructType\DocumentTotals|null
     */
    public function getDocumentTotals()
    {
        return $this->DocumentTotals;
    }
    /**
     * Set DocumentTotals value
     * @param \StructType\DocumentTotals $documentTotals
     * @return \StructType\InvoiceDataType
     */
    public function setDocumentTotals(\StructType\DocumentTotals $documentTotals = null)
    {
        $this->DocumentTotals = $documentTotals;
        return $this;
    }
    /**
     * Get WithholdingTax value
     * @return \StructType\WithholdingTax[]|null
     */
    public function getWithholdingTax()
    {
        return $this->WithholdingTax;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholdingTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxForArrayConstraintsFromSetWithholdingTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceDataTypeWithholdingTaxItem) {
            // validation for constraint: itemType
            if (!$invoiceDataTypeWithholdingTaxItem instanceof \StructType\WithholdingTax) {
                $invalidValues[] = is_object($invoiceDataTypeWithholdingTaxItem) ? get_class($invoiceDataTypeWithholdingTaxItem) : sprintf('%s(%s)', gettype($invoiceDataTypeWithholdingTaxItem), var_export($invoiceDataTypeWithholdingTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTax property can only contain items of type \StructType\WithholdingTax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithholdingTax value
     * @throws \InvalidArgumentException
     * @param \StructType\WithholdingTax[] $withholdingTax
     * @return \StructType\InvoiceDataType
     */
    public function setWithholdingTax(array $withholdingTax = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxArrayErrorMessage = self::validateWithholdingTaxForArrayConstraintsFromSetWithholdingTax($withholdingTax))) {
            throw new \InvalidArgumentException($withholdingTaxArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTax = $withholdingTax;
        return $this;
    }
    /**
     * Add item to WithholdingTax value
     * @throws \InvalidArgumentException
     * @param \StructType\WithholdingTax $item
     * @return \StructType\InvoiceDataType
     */
    public function addToWithholdingTax(\StructType\WithholdingTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WithholdingTax) {
            throw new \InvalidArgumentException(sprintf('The WithholdingTax property can only contain items of type \StructType\WithholdingTax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTax[] = $item;
        return $this;
    }
}
