<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChannelType StructType
 * @subpackage Structs
 */
class ChannelType extends AbstractStructBase
{
    /**
     * The Sistema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Sistema;
    /**
     * The Versao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Versao;
    /**
     * Constructor method for ChannelType
     * @uses ChannelType::setSistema()
     * @uses ChannelType::setVersao()
     * @param string $sistema
     * @param string $versao
     */
    public function __construct($sistema = null, $versao = null)
    {
        $this
            ->setSistema($sistema)
            ->setVersao($versao);
    }
    /**
     * Get Sistema value
     * @return string
     */
    public function getSistema()
    {
        return $this->Sistema;
    }
    /**
     * Set Sistema value
     * @param string $sistema
     * @return \StructType\ChannelType
     */
    public function setSistema($sistema = null)
    {
        // validation for constraint: string
        if (!is_null($sistema) && !is_string($sistema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sistema, true), gettype($sistema)), __LINE__);
        }
        $this->Sistema = $sistema;
        return $this;
    }
    /**
     * Get Versao value
     * @return string|null
     */
    public function getVersao()
    {
        return $this->Versao;
    }
    /**
     * Set Versao value
     * @param string $versao
     * @return \StructType\ChannelType
     */
    public function setVersao($versao = null)
    {
        // validation for constraint: string
        if (!is_null($versao) && !is_string($versao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versao, true), gettype($versao)), __LINE__);
        }
        $this->Versao = $versao;
        return $this;
    }
}
