<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeInvoiceStatusRequest StructType
 * @subpackage Structs
 */
class ChangeInvoiceStatusRequest extends AbstractStructBase
{
    /**
     * The eFaturaMDVersion
     * Meta information extracted from the WSDL
     * - documentation: Versao do webservice.
     * - base: string
     * - pattern: 0.0.1
     * - type: tns:eFaturaMDVersion
     * @var string
     */
    public $eFaturaMDVersion;
    /**
     * The TaxRegistrationNumber
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxInclusive: 999999999
     * - minInclusive: 100000000
     * - ref: tns:TaxRegistrationNumber
     * @var int
     */
    public $TaxRegistrationNumber;
    /**
     * The InvoiceHeader
     * @var \StructType\InvoiceHeaderType
     */
    public $InvoiceHeader;
    /**
     * The InvoiceStatus
     * @var \StructType\NewInvoiceStatusType
     */
    public $InvoiceStatus;
    /**
     * The CanalRegisto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChannelType
     */
    public $CanalRegisto;
    /**
     * Constructor method for ChangeInvoiceStatusRequest
     * @uses ChangeInvoiceStatusRequest::setEFaturaMDVersion()
     * @uses ChangeInvoiceStatusRequest::setTaxRegistrationNumber()
     * @uses ChangeInvoiceStatusRequest::setInvoiceHeader()
     * @uses ChangeInvoiceStatusRequest::setInvoiceStatus()
     * @uses ChangeInvoiceStatusRequest::setCanalRegisto()
     * @param string $eFaturaMDVersion
     * @param int $taxRegistrationNumber
     * @param \StructType\InvoiceHeaderType $invoiceHeader
     * @param \StructType\NewInvoiceStatusType $invoiceStatus
     * @param \StructType\ChannelType $canalRegisto
     */
    public function __construct($eFaturaMDVersion = null, $taxRegistrationNumber = null, \StructType\InvoiceHeaderType $invoiceHeader = null, \StructType\NewInvoiceStatusType $invoiceStatus = null, \StructType\ChannelType $canalRegisto = null)
    {
        $this
            ->setEFaturaMDVersion($eFaturaMDVersion)
            ->setTaxRegistrationNumber($taxRegistrationNumber)
            ->setInvoiceHeader($invoiceHeader)
            ->setInvoiceStatus($invoiceStatus)
            ->setCanalRegisto($canalRegisto);
    }
    /**
     * Get eFaturaMDVersion value
     * @return string|null
     */
    public function getEFaturaMDVersion()
    {
        return $this->eFaturaMDVersion;
    }
    /**
     * Set eFaturaMDVersion value
     * @param string $eFaturaMDVersion
     * @return \StructType\ChangeInvoiceStatusRequest
     */
    public function setEFaturaMDVersion($eFaturaMDVersion = null)
    {
        // validation for constraint: string
        if (!is_null($eFaturaMDVersion) && !is_string($eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eFaturaMDVersion, true), gettype($eFaturaMDVersion)), __LINE__);
        }
        // validation for constraint: pattern(0.0.1)
        if (!is_null($eFaturaMDVersion) && !preg_match('/0.0.1/', $eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 0.0.1', var_export($eFaturaMDVersion, true)), __LINE__);
        }
        $this->eFaturaMDVersion = $eFaturaMDVersion;
        return $this;
    }
    /**
     * Get TaxRegistrationNumber value
     * @return int|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->TaxRegistrationNumber;
    }
    /**
     * Set TaxRegistrationNumber value
     * @param int $taxRegistrationNumber
     * @return \StructType\ChangeInvoiceStatusRequest
     */
    public function setTaxRegistrationNumber($taxRegistrationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($taxRegistrationNumber) && !(is_int($taxRegistrationNumber) || ctype_digit($taxRegistrationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxRegistrationNumber, true), gettype($taxRegistrationNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(100000000)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber < 100000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 100000000', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        $this->TaxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Get InvoiceHeader value
     * @return \StructType\InvoiceHeaderType|null
     */
    public function getInvoiceHeader()
    {
        return $this->InvoiceHeader;
    }
    /**
     * Set InvoiceHeader value
     * @param \StructType\InvoiceHeaderType $invoiceHeader
     * @return \StructType\ChangeInvoiceStatusRequest
     */
    public function setInvoiceHeader(\StructType\InvoiceHeaderType $invoiceHeader = null)
    {
        $this->InvoiceHeader = $invoiceHeader;
        return $this;
    }
    /**
     * Get InvoiceStatus value
     * @return \StructType\NewInvoiceStatusType|null
     */
    public function getInvoiceStatus()
    {
        return $this->InvoiceStatus;
    }
    /**
     * Set InvoiceStatus value
     * @param \StructType\NewInvoiceStatusType $invoiceStatus
     * @return \StructType\ChangeInvoiceStatusRequest
     */
    public function setInvoiceStatus(\StructType\NewInvoiceStatusType $invoiceStatus = null)
    {
        $this->InvoiceStatus = $invoiceStatus;
        return $this;
    }
    /**
     * Get CanalRegisto value
     * @return \StructType\ChannelType|null
     */
    public function getCanalRegisto()
    {
        return $this->CanalRegisto;
    }
    /**
     * Set CanalRegisto value
     * @param \StructType\ChannelType $canalRegisto
     * @return \StructType\ChangeInvoiceStatusRequest
     */
    public function setCanalRegisto(\StructType\ChannelType $canalRegisto = null)
    {
        $this->CanalRegisto = $canalRegisto;
        return $this;
    }
}
