<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InvoiceTypeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Restricao: Tipos de Documento fatura (FT - Fatura, NC-Nota de Credito, ND - Nota de Debito, FS - Fatura Simplificada, FR - Fatura-recibo). Para o setor Segurador (a), ainda pode ser preenchido com: RP para Premio ou recibo de premio,
 * RE para Estorno ou recibo de estorno, CS para Imputacao a co-seguradoras, LD para Imputacao a co-seguradora lider, RA para Resseguro aceite. (a) Para os dados ate 2019-12-31.
 * @subpackage Enumerations
 */
class InvoiceTypeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'FT'
     * @return string 'FT'
     */
    const VALUE_FT = 'FT';
    /**
     * Constant for value 'NC'
     * @return string 'NC'
     */
    const VALUE_NC = 'NC';
    /**
     * Constant for value 'ND'
     * @return string 'ND'
     */
    const VALUE_ND = 'ND';
    /**
     * Constant for value 'FS'
     * @return string 'FS'
     */
    const VALUE_FS = 'FS';
    /**
     * Constant for value 'FR'
     * @return string 'FR'
     */
    const VALUE_FR = 'FR';
    /**
     * Constant for value 'RP'
     * @return string 'RP'
     */
    const VALUE_RP = 'RP';
    /**
     * Constant for value 'RE'
     * @return string 'RE'
     */
    const VALUE_RE = 'RE';
    /**
     * Constant for value 'CS'
     * @return string 'CS'
     */
    const VALUE_CS = 'CS';
    /**
     * Constant for value 'LD'
     * @return string 'LD'
     */
    const VALUE_LD = 'LD';
    /**
     * Constant for value 'RA'
     * @return string 'RA'
     */
    const VALUE_RA = 'RA';
    /**
     * Return allowed values
     * @uses self::VALUE_FT
     * @uses self::VALUE_NC
     * @uses self::VALUE_ND
     * @uses self::VALUE_FS
     * @uses self::VALUE_FR
     * @uses self::VALUE_RP
     * @uses self::VALUE_RE
     * @uses self::VALUE_CS
     * @uses self::VALUE_LD
     * @uses self::VALUE_RA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FT,
            self::VALUE_NC,
            self::VALUE_ND,
            self::VALUE_FS,
            self::VALUE_FR,
            self::VALUE_RP,
            self::VALUE_RE,
            self::VALUE_CS,
            self::VALUE_LD,
            self::VALUE_RA,
        );
    }
}
