<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType StructType
 * @subpackage Structs
 */
class ResponseType extends AbstractStructBase
{
    /**
     * The CodigoResposta
     * @var int
     */
    public $CodigoResposta;
    /**
     * The Mensagem
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 256
     * @var string
     */
    public $Mensagem;
    /**
     * The DataOperacao
     * @var string
     */
    public $DataOperacao;
    /**
     * Constructor method for ResponseType
     * @uses ResponseType::setCodigoResposta()
     * @uses ResponseType::setMensagem()
     * @uses ResponseType::setDataOperacao()
     * @param int $codigoResposta
     * @param string $mensagem
     * @param string $dataOperacao
     */
    public function __construct($codigoResposta = null, $mensagem = null, $dataOperacao = null)
    {
        $this
            ->setCodigoResposta($codigoResposta)
            ->setMensagem($mensagem)
            ->setDataOperacao($dataOperacao);
    }
    /**
     * Get CodigoResposta value
     * @return int|null
     */
    public function getCodigoResposta()
    {
        return $this->CodigoResposta;
    }
    /**
     * Set CodigoResposta value
     * @param int $codigoResposta
     * @return \StructType\ResponseType
     */
    public function setCodigoResposta($codigoResposta = null)
    {
        // validation for constraint: int
        if (!is_null($codigoResposta) && !(is_int($codigoResposta) || ctype_digit($codigoResposta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoResposta, true), gettype($codigoResposta)), __LINE__);
        }
        $this->CodigoResposta = $codigoResposta;
        return $this;
    }
    /**
     * Get Mensagem value
     * @return string|null
     */
    public function getMensagem()
    {
        return $this->Mensagem;
    }
    /**
     * Set Mensagem value
     * @param string $mensagem
     * @return \StructType\ResponseType
     */
    public function setMensagem($mensagem = null)
    {
        // validation for constraint: string
        if (!is_null($mensagem) && !is_string($mensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagem, true), gettype($mensagem)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($mensagem) && mb_strlen($mensagem) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($mensagem)), __LINE__);
        }
        $this->Mensagem = $mensagem;
        return $this;
    }
    /**
     * Get DataOperacao value
     * @return string|null
     */
    public function getDataOperacao()
    {
        return $this->DataOperacao;
    }
    /**
     * Set DataOperacao value
     * @param string $dataOperacao
     * @return \StructType\ResponseType
     */
    public function setDataOperacao($dataOperacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataOperacao) && !is_string($dataOperacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataOperacao, true), gettype($dataOperacao)), __LINE__);
        }
        $this->DataOperacao = $dataOperacao;
        return $this;
    }
}
