<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeWorkStatusRequest StructType
 * @subpackage Structs
 */
class ChangeWorkStatusRequest extends AbstractStructBase
{
    /**
     * The eFaturaMDVersion
     * Meta information extracted from the WSDL
     * - documentation: Versao do webservice.
     * - base: string
     * - pattern: 0.0.1
     * - type: tns:eFaturaMDVersion
     * @var string
     */
    public $eFaturaMDVersion;
    /**
     * The TaxRegistrationNumber
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxInclusive: 999999999
     * - minInclusive: 100000000
     * - ref: tns:TaxRegistrationNumber
     * @var int
     */
    public $TaxRegistrationNumber;
    /**
     * The WorkHeader
     * @var \StructType\WorkHeaderType
     */
    public $WorkHeader;
    /**
     * The WorkStatus
     * @var \StructType\NewWorkStatusType
     */
    public $WorkStatus;
    /**
     * The CanalRegisto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChannelType
     */
    public $CanalRegisto;
    /**
     * Constructor method for ChangeWorkStatusRequest
     * @uses ChangeWorkStatusRequest::setEFaturaMDVersion()
     * @uses ChangeWorkStatusRequest::setTaxRegistrationNumber()
     * @uses ChangeWorkStatusRequest::setWorkHeader()
     * @uses ChangeWorkStatusRequest::setWorkStatus()
     * @uses ChangeWorkStatusRequest::setCanalRegisto()
     * @param string $eFaturaMDVersion
     * @param int $taxRegistrationNumber
     * @param \StructType\WorkHeaderType $workHeader
     * @param \StructType\NewWorkStatusType $workStatus
     * @param \StructType\ChannelType $canalRegisto
     */
    public function __construct($eFaturaMDVersion = null, $taxRegistrationNumber = null, \StructType\WorkHeaderType $workHeader = null, \StructType\NewWorkStatusType $workStatus = null, \StructType\ChannelType $canalRegisto = null)
    {
        $this
            ->setEFaturaMDVersion($eFaturaMDVersion)
            ->setTaxRegistrationNumber($taxRegistrationNumber)
            ->setWorkHeader($workHeader)
            ->setWorkStatus($workStatus)
            ->setCanalRegisto($canalRegisto);
    }
    /**
     * Get eFaturaMDVersion value
     * @return string|null
     */
    public function getEFaturaMDVersion()
    {
        return $this->eFaturaMDVersion;
    }
    /**
     * Set eFaturaMDVersion value
     * @param string $eFaturaMDVersion
     * @return \StructType\ChangeWorkStatusRequest
     */
    public function setEFaturaMDVersion($eFaturaMDVersion = null)
    {
        // validation for constraint: string
        if (!is_null($eFaturaMDVersion) && !is_string($eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eFaturaMDVersion, true), gettype($eFaturaMDVersion)), __LINE__);
        }
        // validation for constraint: pattern(0.0.1)
        if (!is_null($eFaturaMDVersion) && !preg_match('/0.0.1/', $eFaturaMDVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 0.0.1', var_export($eFaturaMDVersion, true)), __LINE__);
        }
        $this->eFaturaMDVersion = $eFaturaMDVersion;
        return $this;
    }
    /**
     * Get TaxRegistrationNumber value
     * @return int|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->TaxRegistrationNumber;
    }
    /**
     * Set TaxRegistrationNumber value
     * @param int $taxRegistrationNumber
     * @return \StructType\ChangeWorkStatusRequest
     */
    public function setTaxRegistrationNumber($taxRegistrationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($taxRegistrationNumber) && !(is_int($taxRegistrationNumber) || ctype_digit($taxRegistrationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxRegistrationNumber, true), gettype($taxRegistrationNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(100000000)
        if (!is_null($taxRegistrationNumber) && $taxRegistrationNumber < 100000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 100000000', var_export($taxRegistrationNumber, true)), __LINE__);
        }
        $this->TaxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Get WorkHeader value
     * @return \StructType\WorkHeaderType|null
     */
    public function getWorkHeader()
    {
        return $this->WorkHeader;
    }
    /**
     * Set WorkHeader value
     * @param \StructType\WorkHeaderType $workHeader
     * @return \StructType\ChangeWorkStatusRequest
     */
    public function setWorkHeader(\StructType\WorkHeaderType $workHeader = null)
    {
        $this->WorkHeader = $workHeader;
        return $this;
    }
    /**
     * Get WorkStatus value
     * @return \StructType\NewWorkStatusType|null
     */
    public function getWorkStatus()
    {
        return $this->WorkStatus;
    }
    /**
     * Set WorkStatus value
     * @param \StructType\NewWorkStatusType $workStatus
     * @return \StructType\ChangeWorkStatusRequest
     */
    public function setWorkStatus(\StructType\NewWorkStatusType $workStatus = null)
    {
        $this->WorkStatus = $workStatus;
        return $this;
    }
    /**
     * Get CanalRegisto value
     * @return \StructType\ChannelType|null
     */
    public function getCanalRegisto()
    {
        return $this->CanalRegisto;
    }
    /**
     * Set CanalRegisto value
     * @param \StructType\ChannelType $canalRegisto
     * @return \StructType\ChangeWorkStatusRequest
     */
    public function setCanalRegisto(\StructType\ChannelType $canalRegisto = null)
    {
        $this->CanalRegisto = $canalRegisto;
        return $this;
    }
}
