<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegisterInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterInvoiceRequest $registerInvoiceRequest
     * @return \StructType\RegisterInvoiceResponse|bool
     */
    public function RegisterInvoice(\StructType\RegisterInvoiceRequest $registerInvoiceRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterInvoice($registerInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterWork
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterWorkRequest $registerWorkRequest
     * @return \StructType\RegisterWorkResponse|bool
     */
    public function RegisterWork(\StructType\RegisterWorkRequest $registerWorkRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterWork($registerWorkRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterPaymentRequest $registerPaymentRequest
     * @return \StructType\RegisterPaymentResponse|bool
     */
    public function RegisterPayment(\StructType\RegisterPaymentRequest $registerPaymentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterPayment($registerPaymentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RegisterInvoiceResponse|\StructType\RegisterPaymentResponse|\StructType\RegisterWorkResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
