<?php

namespace AgrioApi\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getInvoiceRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Retourneren van de factuur.<BR> Op basis van het factuurnummer wordt de factuur opgezocht.<BR> Het relatienummer dient ter controle of het relatienummer bij het factuurnummer hoort.<BR> De factuur wordt geprint in PDF-formaat en
 * geretourneerd in Base64Binary formaat.
 * @subpackage Structs
 * @date 20221122 package
 */
class GetInvoiceRequest extends AbstractStructBase
{
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - documentation: Het factuurnummer van de op te vragen factuur.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $invoiceNumber;
    /**
     * The relatieNummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de debiteur.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getInvoiceRequest
     * @uses GetInvoiceRequest::setInvoiceNumber()
     * @uses GetInvoiceRequest::setRelatieNummer()
     * @uses GetInvoiceRequest::setRequestTag()
     * @param string $invoiceNumber
     * @param int $relatieNummer
     * @param string $requestTag
     */
    public function __construct($invoiceNumber = null, $relatieNummer = null, $requestTag = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setRelatieNummer($relatieNummer)
            ->setRequestTag($requestTag);
    }
    /**
     * Get invoiceNumber value
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \AgrioApi\StructType\GetInvoiceRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($invoiceNumber) && mb_strlen($invoiceNumber) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($invoiceNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invoiceNumber) && mb_strlen($invoiceNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get relatieNummer value
     * @return int
     */
    public function getRelatieNummer()
    {
        return $this->relatieNummer;
    }
    /**
     * Set relatieNummer value
     * @param int $relatieNummer
     * @return \AgrioApi\StructType\GetInvoiceRequest
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        $this->relatieNummer = $relatieNummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AgrioApi\StructType\GetInvoiceRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
