<?php

namespace AgrioApi\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20221122 package
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AgrioApi\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\AgrioApi\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getInvoice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \AgrioApi\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retourneren van de factuur.<BR> Op basis van het factuurnummer wordt de factuur opgezocht.<BR> Het relatienummer dient ter controle of het relatienummer bij het factuurnummer hoort.<BR> De factuur wordt geprint in PDF-formaat en
     * geretourneerd in Base64Binary formaat.error506: Er is geen relatie gevonden met het opgegeven relatienummererror507: Er is geen factuur gevonden met het opgegeven factuurnummererror508: De factuur en het opgegeven relatienummer horen niet bij
     * elkaarerror509: Voor de gekozen factuur kan geen layout bepaald wordenerror510: Er is een fout opgetreden bij het samenstellen van de PDF (--opgetreden fout--)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AgrioApi\StructType\GetInvoiceRequest $request_parameters
     * @return \AgrioApi\StructType\GetInvoiceResponse|bool
     */
    public function getInvoice(\AgrioApi\StructType\GetInvoiceRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoice($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AgrioApi\StructType\GetInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
