<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierTrasETD StructType
 * @subpackage Structs
 */
class SupplierTrasETD extends AbstractStructBase
{
    /**
     * The Rut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Rut;
    /**
     * Constructor method for SupplierTrasETD
     * @uses SupplierTrasETD::setRut()
     * @param int $rut
     */
    public function __construct($rut = null)
    {
        $this
            ->setRut($rut);
    }
    /**
     * Get Rut value
     * @return int
     */
    public function getRut()
    {
        return $this->Rut;
    }
    /**
     * Set Rut value
     * @param int $rut
     * @return \StructType\SupplierTrasETD
     */
    public function setRut($rut = null)
    {
        // validation for constraint: int
        if (!is_null($rut) && !(is_int($rut) || ctype_digit($rut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rut, true), gettype($rut)), __LINE__);
        }
        $this->Rut = $rut;
        return $this;
    }
}
