<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumento ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumento extends AbstractStructArrayBase
{
    /**
     * The Documento
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Documento[]
     */
    public $Documento;
    /**
     * Constructor method for ArrayOfDocumento
     * @uses ArrayOfDocumento::setDocumento()
     * @param \StructType\Documento[] $documento
     */
    public function __construct(array $documento = array())
    {
        $this
            ->setDocumento($documento);
    }
    /**
     * Get Documento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Documento[]|null
     */
    public function getDocumento()
    {
        return isset($this->Documento) ? $this->Documento : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumento method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumento method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentoForArrayConstraintsFromSetDocumento(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentoDocumentoItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentoDocumentoItem instanceof \StructType\Documento) {
                $invalidValues[] = is_object($arrayOfDocumentoDocumentoItem) ? get_class($arrayOfDocumentoDocumentoItem) : sprintf('%s(%s)', gettype($arrayOfDocumentoDocumentoItem), var_export($arrayOfDocumentoDocumentoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Documento property can only contain items of type \StructType\Documento, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Documento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Documento[] $documento
     * @return \ArrayType\ArrayOfDocumento
     */
    public function setDocumento(array $documento = array())
    {
        // validation for constraint: array
        if ('' !== ($documentoArrayErrorMessage = self::validateDocumentoForArrayConstraintsFromSetDocumento($documento))) {
            throw new \InvalidArgumentException($documentoArrayErrorMessage, __LINE__);
        }
        if (is_null($documento) || (is_array($documento) && empty($documento))) {
            unset($this->Documento);
        } else {
            $this->Documento = $documento;
        }
        return $this;
    }
    /**
     * Add item to Documento value
     * @throws \InvalidArgumentException
     * @param \StructType\Documento $item
     * @return \ArrayType\ArrayOfDocumento
     */
    public function addToDocumento(\StructType\Documento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Documento) {
            throw new \InvalidArgumentException(sprintf('The Documento property can only contain items of type \StructType\Documento, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Documento[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Documento|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Documento|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Documento|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Documento|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Documento|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Documento
     */
    public function getAttributeName()
    {
        return 'Documento';
    }
}
