<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Actualiza ServiceType
 * @subpackage Services
 */
class Actualiza extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ActualizaEstadoDTE
     * Meta information extracted from the WSDL
     * - documentation: Actualiza Estado de Traspaso de DTE.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActualizaEstadoDTE $parameters
     * @return \StructType\ActualizaEstadoDTEResponse|bool
     */
    public function ActualizaEstadoDTE(\StructType\ActualizaEstadoDTE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActualizaEstadoDTE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ActualizaEstadoDTEResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
