<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rescata ServiceType
 * @subpackage Services
 */
class Rescata extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RescataListadoDTE
     * Meta information extracted from the WSDL
     * - documentation: Permite Rescatar Listado de DTEs, no recepcionados en ERP, para una empresa dada.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RescataListadoDTE $parameters
     * @return \StructType\RescataListadoDTEResponse|bool
     */
    public function RescataListadoDTE(\StructType\RescataListadoDTE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RescataListadoDTE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RescataXMLDTE
     * Meta information extracted from the WSDL
     * - documentation: Rescata datos de Encabezado y XML de DTO.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RescataXMLDTE $parameters
     * @return \StructType\RescataXMLDTEResponse|bool
     */
    public function RescataXMLDTE(\StructType\RescataXMLDTE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RescataXMLDTE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RescataListadoDTEResponse|\StructType\RescataXMLDTEResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
