<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://fewss02-cert.cl.dbnetcorp.com/DTOWSS_V2/wssSupplierETD/wssSupplierETD.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://fewss02-cert.cl.dbnetcorp.com/DTOWSS_V2/wssSupplierETD/wssSupplierETD.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Supplier ServiceType
 */
$supplier = new \ServiceType\Supplier($options);
/**
 * Sample call for SupplierTrasETD operation/method
 */
if ($supplier->SupplierTrasETD(new \StructType\SupplierTrasETD()) !== false) {
    print_r($supplier->getResult());
} else {
    print_r($supplier->getLastError());
}
/**
 * Samples for Rescata ServiceType
 */
$rescata = new \ServiceType\Rescata($options);
/**
 * Sample call for RescataListadoDTE operation/method
 */
if ($rescata->RescataListadoDTE(new \StructType\RescataListadoDTE()) !== false) {
    print_r($rescata->getResult());
} else {
    print_r($rescata->getLastError());
}
/**
 * Sample call for RescataXMLDTE operation/method
 */
if ($rescata->RescataXMLDTE(new \StructType\RescataXMLDTE()) !== false) {
    print_r($rescata->getResult());
} else {
    print_r($rescata->getLastError());
}
/**
 * Samples for Actualiza ServiceType
 */
$actualiza = new \ServiceType\Actualiza($options);
/**
 * Sample call for ActualizaEstadoDTE operation/method
 */
if ($actualiza->ActualizaEstadoDTE(new \StructType\ActualizaEstadoDTE()) !== false) {
    print_r($actualiza->getResult());
} else {
    print_r($actualiza->getLastError());
}
