<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateABARequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateABARequest
 * @subpackage Structs
 */
class ValidateABARequest extends AbstractStructBase
{
    /**
     * The ABANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ABANumber;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * Constructor method for ValidateABARequest
     * @uses ValidateABARequest::setABANumber()
     * @uses ValidateABARequest::setMethodID()
     * @uses ValidateABARequest::setOrgID()
     * @param string $aBANumber
     * @param string $methodID
     * @param string $orgID
     */
    public function __construct($aBANumber = null, $methodID = null, $orgID = null)
    {
        $this
            ->setABANumber($aBANumber)
            ->setMethodID($methodID)
            ->setOrgID($orgID);
    }
    /**
     * Get ABANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getABANumber()
    {
        return isset($this->ABANumber) ? $this->ABANumber : null;
    }
    /**
     * Set ABANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aBANumber
     * @return \StructType\ValidateABARequest
     */
    public function setABANumber($aBANumber = null)
    {
        // validation for constraint: string
        if (!is_null($aBANumber) && !is_string($aBANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBANumber, true), gettype($aBANumber)), __LINE__);
        }
        if (is_null($aBANumber) || (is_array($aBANumber) && empty($aBANumber))) {
            unset($this->ABANumber);
        } else {
            $this->ABANumber = $aBANumber;
        }
        return $this;
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\ValidateABARequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\ValidateABARequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
}
