<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayeeOperationResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PayeeOperationResult
 * @subpackage Structs
 */
class PayeeOperationResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The PayeeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeId;
    /**
     * The PayeeInternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeInternalReference;
    /**
     * The PayeeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayeeName;
    /**
     * Constructor method for PayeeOperationResult
     * @uses PayeeOperationResult::setErrorCode()
     * @uses PayeeOperationResult::setErrorMessage()
     * @uses PayeeOperationResult::setPayeeId()
     * @uses PayeeOperationResult::setPayeeInternalReference()
     * @uses PayeeOperationResult::setPayeeName()
     * @param int $errorCode
     * @param string $errorMessage
     * @param string $payeeId
     * @param string $payeeInternalReference
     * @param string $payeeName
     */
    public function __construct($errorCode = null, $errorMessage = null, $payeeId = null, $payeeInternalReference = null, $payeeName = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setPayeeId($payeeId)
            ->setPayeeInternalReference($payeeInternalReference)
            ->setPayeeName($payeeName);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\PayeeOperationResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\PayeeOperationResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get PayeeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeId()
    {
        return isset($this->PayeeId) ? $this->PayeeId : null;
    }
    /**
     * Set PayeeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeId
     * @return \StructType\PayeeOperationResult
     */
    public function setPayeeId($payeeId = null)
    {
        // validation for constraint: string
        if (!is_null($payeeId) && !is_string($payeeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeId, true), gettype($payeeId)), __LINE__);
        }
        if (is_null($payeeId) || (is_array($payeeId) && empty($payeeId))) {
            unset($this->PayeeId);
        } else {
            $this->PayeeId = $payeeId;
        }
        return $this;
    }
    /**
     * Get PayeeInternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeInternalReference()
    {
        return isset($this->PayeeInternalReference) ? $this->PayeeInternalReference : null;
    }
    /**
     * Set PayeeInternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeInternalReference
     * @return \StructType\PayeeOperationResult
     */
    public function setPayeeInternalReference($payeeInternalReference = null)
    {
        // validation for constraint: string
        if (!is_null($payeeInternalReference) && !is_string($payeeInternalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeInternalReference, true), gettype($payeeInternalReference)), __LINE__);
        }
        if (is_null($payeeInternalReference) || (is_array($payeeInternalReference) && empty($payeeInternalReference))) {
            unset($this->PayeeInternalReference);
        } else {
            $this->PayeeInternalReference = $payeeInternalReference;
        }
        return $this;
    }
    /**
     * Get PayeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayeeName()
    {
        return isset($this->PayeeName) ? $this->PayeeName : null;
    }
    /**
     * Set PayeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payeeName
     * @return \StructType\PayeeOperationResult
     */
    public function setPayeeName($payeeName = null)
    {
        // validation for constraint: string
        if (!is_null($payeeName) && !is_string($payeeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeName, true), gettype($payeeName)), __LINE__);
        }
        if (is_null($payeeName) || (is_array($payeeName) && empty($payeeName))) {
            unset($this->PayeeName);
        } else {
            $this->PayeeName = $payeeName;
        }
        return $this;
    }
}
